/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.Clear;
import Sav.Processor.ClearConnection;
import Sav.Processor.Concept;
import Sav.Processor.ExtendClass;
import Sav.Processor.Get;
import Sav.Processor.GetBy;
import Sav.Processor.GetConnection;
import Sav.Processor.GetConnectionList;
import Sav.Processor.GetPower;
import Sav.Processor.Has;
import Sav.Processor.HasConnection;
import Sav.Processor.Hub;
import Sav.Processor.Int1;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Processor.Set;
import Sav.Processor.SetCConnection;
import Sav.Processor.SetConnection;
import Sav.Processor.Trace;
import java.io.IOException;
import java.io.PrintWriter;

class Node
implements Cloneable {
    Node ancestor;
    int notation;
    int mark;
    int count = 0;
    int nextType;
    int first;
    int last;
    Node descendant;
    Node[] posterity;
    boolean changed;
    Hub hub;
    int onset;
    int size;
    byte[] block;
    int address = -1;
    long power;
    Node powerNode;

    Node() {
        this.mark = 39;
    }

    Node(int n) {
        this.mark = n;
        if (n > 31) {
            this.notation = n;
        }
    }

    Node(Hub hub) {
        this.hub = hub;
        this.notation = 39;
        this.mark = 39;
    }

    Node(Hub hub, int n) {
        this.hub = hub;
        this.mark = n;
        if (n > 31) {
            this.notation = n;
        }
    }

    Node(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            this.count = 0;
        } else {
            this.count = -1;
            this.size = n2;
            this.onset = n;
            this.block = byArray;
        }
    }

    public Object clone(Node node) {
        Node node2 = null;
        try {
            node2 = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        if (this.count == 1) {
            node2.descendant = (Node)this.descendant.clone(node2);
        } else if (this.count > 1) {
            int n = this.last & 0x1F;
            node2.posterity = new Node[32];
            for (int i = this.first & 0x1F; i <= n; ++i) {
                if (this.posterity[i] == null) continue;
                node2.posterity[i] = (Node)this.posterity[i].clone(node2);
            }
        }
        node2.ancestor = node;
        return node2;
    }

    int deploy() throws IOException {
        Node node;
        int n;
        int n2;
        if (this.count >= 0) {
            return this.count;
        }
        Int1 int1 = new Int1(0);
        int n3 = this.onset;
        if (this.block == null) {
            this.count = 0;
            return this.count;
        }
        if ((n2 = this.block[n3++] & 0xFF) >= 192) {
            PN.readAddress(this.block, this.onset, int1);
            this.address = int1.value;
            if (this.address == 0 && this.hub.af.bind == null) {
                this.hub.af.open();
            }
            this.block = this.hub.af.read(this.address);
            if (this.block == null) {
                this.count = 0;
                this.address = -1;
                return this.count;
            }
            n3 = PN.readSize(this.block, 0, int1);
            this.size = int1.value;
            this.onset = n3;
            n2 = this.block[n3++] & 0xFF;
        }
        this.nextType = n2 & 0x20;
        if (n2 >= 128) {
            int n4;
            int n5;
            int n6 = 0;
            this.first = 3;
            for (n5 = 0; n5 < 4; ++n5) {
                if ((n2 & 1 << n5) == 0) continue;
                n6 |= (this.block[n3++] & 0xFF) << (n5 << 3);
                if (this.first > n5) {
                    this.first = n5;
                }
                this.last = n5;
            }
            this.last = (this.last << 3) + 7;
            int n7 = 1 << this.last;
            while ((n6 & n7) == 0) {
                --this.last;
                n7 >>>= 1;
            }
            this.first <<= 3;
            n7 = 1 << this.first;
            while ((n6 & n7) == 0) {
                ++this.first;
                n7 <<= 1;
            }
            if (this.nextType > 0 && this.first == 0) {
                n3 = PN.readSize(this.block, n3, int1);
                n4 = int1.value;
                this.powerNode = new Node(this.block, n3, n4);
                n3 += n4;
                ++this.first;
                n7 <<= 1;
                while ((n6 & n7) == 0) {
                    ++this.first;
                    n7 <<= 1;
                }
                if (this.first == this.last) {
                    this.count = 1;
                    n3 = PN.readSize(this.block, n3, int1);
                    n4 = int1.value;
                    this.descendant = new Node(this.block, n3, n4);
                    this.propagate(this.nextType | this.first, this.descendant);
                    this.first |= this.nextType;
                    this.last |= this.nextType;
                    return this.count;
                }
            }
            this.count = 0;
            this.posterity = new Node[32];
            n5 = this.first;
            while (n5 <= this.last) {
                if ((n6 & n7) != 0) {
                    ++this.count;
                    n3 = PN.readSize(this.block, n3, int1);
                    n4 = int1.value;
                    this.posterity[n5] = new Node(this.block, n3, n4);
                    n3 += n4;
                    this.propagate(this.nextType | n5, this.posterity[n5]);
                }
                ++n5;
                n7 <<= 1;
            }
            this.first |= this.nextType;
            this.last |= this.nextType;
            return this.count;
        }
        int n8 = 0;
        int n9 = n3;
        Node node2 = this;
        if (n2 >= 64) {
            int n10 = n2 & 0x1F;
            int n11 = this.block[n3++] & 0xFF;
            int n12 = 8;
            while (true) {
                n8 = n11 & 0x1F;
                n = this.nextType | n8;
                n11 >>= 5;
                n12 -= 5;
                if (n10-- == 0) break;
                node = new Node();
                node2.count = 1;
                node2.nextType = this.nextType;
                node2.first = n;
                node2.last = n;
                node2.descendant = node;
                node2.propagate(n, node);
                node2 = node;
                if (n12 >= 5) continue;
                n11 |= (this.block[n3++] & 0xFF) << n12;
                n12 += 8;
            }
            node = new Node(this.block, n3, this.size - 1 - (n3 - n9));
        } else {
            n8 = n2 & 0x1F;
            n = this.nextType | n8;
            node = new Node(this.block, n3, this.size - 1);
        }
        node2.count = 1;
        node2.nextType = this.nextType;
        node2.first = n;
        node2.last = n;
        node2.descendant = node;
        node2.propagate(n, node);
        return 1;
    }

    void propagate(int n, Node node) {
        node.ancestor = this;
        node.hub = this.hub;
        node.mark = n;
        node.notation = n >= 56 ? 39 : (n > 31 ? n : this.notation);
    }

    void infix(int n) {
        Node node = new Node();
        node.count = this.count;
        node.nextType = this.nextType;
        node.first = this.first;
        node.last = this.last;
        node.descendant = this.descendant;
        node.posterity = this.posterity;
        node.changed = this.changed;
        node.onset = this.onset;
        node.size = this.size;
        node.block = this.block;
        if (this.address == 0 && this.ancestor == null) {
            node.address = -1;
        } else {
            node.address = this.address;
            this.address = -1;
        }
        if (this.count == 1) {
            this.descendant.ancestor = node;
        } else {
            int n2 = this.first & 0x1F;
            int n3 = this.last & 0x1F;
            for (int i = n2; i <= n3; ++i) {
                Node node2 = this.posterity[i];
                if (node2 == null) continue;
                node2.ancestor = node;
            }
            this.posterity = null;
        }
        this.count = 0;
        this.setIndex(n, node);
    }

    Node getIndex(int n) {
        if (this.count == 0) {
            return null;
        }
        if (this.count == 1) {
            if (n == this.first) {
                return this.descendant;
            }
            return null;
        }
        return this.posterity[n & 0x1F];
    }

    boolean hasIndex(int n) throws IOException {
        if (this.count == 0) {
            return false;
        }
        if (this.last == n) {
            return true;
        }
        if (this.count == 1) {
            return false;
        }
        return this.posterity[n & 0x1F] != null;
    }

    void setIndex(int n, Node node) {
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        int n4 = n & 0x1F;
        if (this.count == 0) {
            if (n > 57) {
                this.upperPower();
            }
            this.count = 1;
            this.nextType = n & 0x20;
            this.first = n;
            this.last = n;
            this.descendant = node;
            this.propagate(n, node);
            return;
        }
        if (this.count == 1) {
            if (n2 == n4) {
                this.descendant = node;
                this.propagate(n, node);
                return;
            }
            this.posterity = new Node[32];
            this.posterity[n2] = this.descendant;
            this.descendant = null;
        }
        if (this.posterity[n4] != null) {
            this.posterity[n4] = node;
            this.propagate(n, node);
            return;
        }
        if (n > 57 && this.last <= 57) {
            this.upperPower();
        }
        ++this.count;
        if (n4 < n2) {
            this.first = this.nextType | n4;
        } else if (n4 > n3) {
            this.last = this.nextType | n4;
        }
        this.posterity[n4] = node;
        this.propagate(n, node);
    }

    Node getMark(int n) throws IOException {
        if (this.deploy() == 0) {
            return null;
        }
        if (this.nextType < (n & 0x20)) {
            if (this.notation == n) {
                return this;
            }
            return null;
        }
        if (this.nextType > (n & 0x20)) {
            Node node = this.getIndex(this.notation);
            if (node == null) {
                return null;
            }
            return node.getMark(n);
        }
        return this.getIndex(n);
    }

    boolean hasMark() throws IOException {
        return this.deploy() != 0;
    }

    boolean hasMark(int n) throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        if (this.nextType < (n & 0x20)) {
            return this.notation == n;
        }
        if (this.nextType > (n & 0x20)) {
            Node node = this.getIndex(this.notation);
            if (node == null) {
                return false;
            }
            return node.hasMark(n);
        }
        return this.hasIndex(n);
    }

    public boolean hasDenotation() throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        if (this.nextType == 0) {
            return this.notation > 36;
        }
        if (this.first >= 57) {
            return false;
        }
        if (this.last <= 36) {
            return false;
        }
        if (this.count == 1) {
            return true;
        }
        int n = 5;
        int n2 = 24;
        for (int i = n; i <= n2; ++i) {
            Node node = this.posterity[i];
            if (node == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasDesignation() throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        if (this.nextType == 0) {
            return this.notation <= 36;
        }
        if (this.first > 36) {
            return false;
        }
        if (this.last < 32) {
            return false;
        }
        if (this.count == 1) {
            return true;
        }
        int n = 1;
        int n2 = 4;
        for (int i = n; i <= n2; ++i) {
            Node node = this.posterity[i];
            if (node == null) continue;
            return true;
        }
        return false;
    }

    boolean setMark(int n) throws IOException {
        return this.setMark(n, new Node());
    }

    boolean setMark(int n, Node node) throws IOException {
        Node node2 = this.getMark(n);
        if (node2 != null) {
            return false;
        }
        if (this.count == 0 || (n & 0x20) == this.nextType) {
            this.setIndex(n, node);
        } else if ((n & 0x20) < this.nextType) {
            node2 = new Node();
            this.setIndex(this.notation, node2);
            node2.setIndex(n, node);
        } else {
            this.infix(this.notation);
            this.setIndex(n, node);
        }
        return true;
    }

    boolean clearMark() throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        this.clearMark1();
        this.setChange();
        return true;
    }

    void clearMark1() throws IOException {
        if (this.deploy() == 0) {
            return;
        }
        if (this.last > 57) {
            this.lowerPower();
        }
        if (this.count == 1) {
            Node node = this.descendant;
            node.clearMark1();
            if (node.address >= 0) {
                this.hub.af.free(node.address);
                node.address = -1;
            }
            this.count = 0;
            this.descendant = null;
            return;
        }
        int n = this.first & 0x1F;
        int n2 = this.last & 0x1F;
        for (int i = n; i <= n2; ++i) {
            Node node = this.posterity[i];
            if (node == null) continue;
            node.clearMark1();
            if (node.address < 0) continue;
            this.hub.af.free(node.address);
            node.address = -1;
        }
        this.count = 0;
        this.posterity = null;
    }

    boolean clearMark(int n) throws IOException {
        Node node = this.getMark(n);
        if (node == null) {
            return false;
        }
        node.clearMark();
        if ((n & 0x20) == this.nextType) {
            this.clearIndex(n);
        } else if ((n & 0x20) < this.nextType) {
            Node node2 = this.getIndex(this.notation);
            if (node2.count == 0) {
                this.clearIndex(this.notation);
            }
        }
        this.setChange();
        return true;
    }

    boolean clearIndex(int n) throws IOException {
        if (this.count == 0) {
            return false;
        }
        if (this.count == 1) {
            if (this.first == n) {
                if (n > 57) {
                    this.lowerPower();
                }
                this.count = 0;
                this.descendant = null;
                return true;
            }
            return false;
        }
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        int n4 = n & 0x1F;
        if (this.posterity[n4] == null) {
            return false;
        }
        --this.count;
        if (this.count == 1) {
            if (n4 == n2) {
                this.first = this.last;
            } else {
                this.last = this.first;
            }
            this.descendant = this.posterity[this.first & 0x1F];
            this.posterity = null;
        } else {
            this.posterity[n4] = null;
            if (n4 == n2) {
                n4 = n2 + 1;
                while (this.posterity[n4] == null) {
                    ++n4;
                }
                this.first = this.nextType | n4;
            } else if (n4 == n3) {
                n4 = n3 - 1;
                while (this.posterity[n4] == null) {
                    --n4;
                }
                this.last = this.nextType | n4;
            }
        }
        if (n > 57 && this.last < 57) {
            this.lowerPower();
        }
        return true;
    }

    void definePower() {
        Node node;
        int n;
        if (this.first > 57) {
            return;
        }
        if (this.last > 57) {
            this.power = 1L;
        }
        if (this.count == 1) {
            this.power = this.descendant.power;
            if (this.last < 57) {
                this.descendant.power = 0L;
            }
            return;
        }
        int n2 = this.first & 0x1F;
        if (this.last < 57) {
            n = this.last & 0x1F;
        } else {
            n = 25;
            if ((node = this.posterity[n--]) != null) {
                this.power = node.power;
            }
        }
        for (int i = n2; i <= n; ++i) {
            node = this.posterity[i];
            if (node == null) continue;
            this.power += node.power;
            node.power = 0L;
        }
    }

    int getDegree() throws IOException {
        int n = 0;
        if (this.mark != 36) {
            return -1;
        }
        Node node = this;
        while (node.deploy() > 0 && node.nextType == 0) {
            ++n;
            node = node.getIndex(node.first);
        }
        return n;
    }

    Node getFooting(int n) {
        Node node = this;
        for (int i = 0; i < n; ++i) {
            if ((node = node.getIndex(0)) != null) continue;
            return null;
        }
        return node;
    }

    void infixFooting(int n) {
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.infix(0);
        }
        Node node = this.getFooting(n - 1);
        node.setChange();
    }

    Node setFooting(int n) {
        if (n == 0) {
            return this;
        }
        Node node = this.getIndex(0);
        if (node == null) {
            node = new Node();
            this.setIndex(0, node);
            return node.setFooting(n - 1);
        }
        return node.setFooting(n - 1);
    }

    Node getTrace(Trace trace) throws IOException {
        return this.getTrace(trace, 62);
    }

    Node getTrace(Trace trace, int n) throws IOException {
        Node node = this;
        Trace trace2 = trace.next;
        while (trace2 != null) {
            int n2;
            int n3;
            if (node.deploy() == 0) {
                return null;
            }
            if (trace2.mark > n) {
                return null;
            }
            if ((node = node.getMark(trace2.mark)) == null) {
                return null;
            }
            if (trace2.mark == 36 && trace2.next != null && ((n3 = node.getDegree()) < (n2 = this.getTraceDegree(trace2)) ? (trace2 = this.getTraceFooting(trace2, n2 - n3)) == null : n3 > n2 && (node = node.getFooting(n3 - n2)) == null)) {
                return null;
            }
            trace2 = trace2.next;
        }
        return node;
    }

    int getTraceDegree(Trace trace) {
        int n = 0;
        Trace trace2 = trace.next;
        while (trace2 != null) {
            if (trace2.mark > 31) {
                return n;
            }
            ++n;
            trace2 = trace2.next;
        }
        return n;
    }

    Trace getTraceFooting(Trace trace, int n) {
        Trace trace2 = trace;
        for (int i = 0; i < n; ++i) {
            trace2 = trace2.next;
            if (trace2 != null && trace2.mark == 0) continue;
            return null;
        }
        return trace2;
    }

    Node setTrace(Trace trace) throws IOException {
        int n;
        Trace trace2 = trace.next;
        if (trace2 == null) {
            return this;
        }
        if (this.notation == trace2.mark) {
            return this.setTrace(trace2);
        }
        if (this.deploy() == 0) {
            Node node = new Node();
            this.setIndex(trace2.mark, node);
            return node.setTrace(trace2);
        }
        int n2 = trace2.mark & 0x20;
        if (this.nextType < n2) {
            this.infix(this.notation);
        }
        if (this.nextType > n2) {
            n = this.notation;
            trace2 = trace;
        } else {
            n = trace2.mark;
        }
        Node node = this.getIndex(n);
        if (node == null) {
            node = new Node();
            this.setIndex(n, node);
            return node.setTrace(trace2);
        }
        if (n == 36) {
            int n3;
            int n4 = node.getDegree();
            if (n4 < (n3 = this.getTraceDegree(trace2))) {
                node.infixFooting(n3 - n4);
            } else if (n4 > n3) {
                node = node.setFooting(n4 - n3);
            }
        }
        return node.setTrace(trace2);
    }

    Node clearTrace(Trace trace) throws IOException {
        int n;
        int n2;
        int n3;
        Trace trace2 = trace.next;
        if (this.deploy() == 0) {
            return this;
        }
        if (trace2 == null) {
            return this;
        }
        int n4 = trace2.mark & 0x20;
        if (this.nextType < n4) {
            if (this.notation != trace2.mark) {
                return this;
            }
            return this.clearTrace(trace2);
        }
        if (this.nextType > n4) {
            n3 = this.notation;
            trace2 = trace;
        } else {
            n3 = trace2.mark;
        }
        Node node = this.getIndex(n3);
        if (node == null) {
            return this;
        }
        if (trace2.mark == 36 && ((n2 = node.getDegree()) < (n = this.getTraceDegree(trace2)) ? (trace2 = this.getTraceFooting(trace2, n - n2)) == null : n2 > n && (node = node.getFooting(n2 - n)) == null)) {
            return this;
        }
        Node node2 = node.clearTrace(trace2);
        if (node.count != 0) {
            return node2;
        }
        if (node.address >= 0) {
            this.hub.af.free(node.address);
            node.address = -1;
        }
        this.clearMark(n3);
        return this;
    }

    void setChange() {
        Node node = this;
        while (node != null) {
            if (node.changed && node.size == 0) {
                return;
            }
            node.changed = true;
            node.onset = 0;
            node.size = 0;
            node.block = null;
            node = node.ancestor;
        }
    }

    void pack() throws IOException {
        int n;
        int n2;
        Node node = null;
        if (this.count <= 0) {
            return;
        }
        if (this.size > 0) {
            return;
        }
        if (this.power > (long)0 && this.powerNode == null) {
            this.packPower();
        }
        if (this.powerNode != null && this.nextType == 0) {
            this.infix(this.notation);
        }
        if (this.count == 1 && this.powerNode == null) {
            node = this.descendant;
            int n3 = 1;
            if (this.nextType == 0) {
                while (node.count == 1) {
                    if (node.first == node.notation) {
                        node.jam(node.descendant);
                    }
                    if (node.nextType != 0 || node.address >= 0) break;
                    node = node.descendant;
                    if (++n3 <= 31) continue;
                }
                if (n3 == 2) {
                    node = this.descendant;
                    n3 = 1;
                }
            }
            if (n3 == 1) {
                this.size = 1;
                this.block = new byte[this.size];
                this.block[0] = (byte)node.mark;
            } else {
                this.size = (int)Math.ceil((double)n3 * (double)5 / (double)8) + 1;
                this.block = new byte[this.size];
                this.block[0] = (byte)(0x40 | this.nextType | n3 - 1);
                int n4 = 1;
                int n5 = 0;
                int n6 = 0;
                node = this.descendant;
                while (true) {
                    n6 |= (node.mark & 0x1F) << n5;
                    if ((n5 += 5) > 7) {
                        this.block[n4++] = (byte)n6;
                        n6 >>= 8;
                        n5 -= 8;
                    }
                    if (--n3 == 0) break;
                    if (!node.changed) {
                        node.changed = true;
                        node.size = 0;
                        node.block = null;
                        node.onset = 0;
                    }
                    node = node.descendant;
                }
                if (n5 > 0) {
                    this.block[n4++] = (byte)n6;
                }
            }
            node.pack();
            if (node.address >= 0) {
                if (this.size + node.size <= 8190) {
                    if (this.address < 0) {
                        this.address = node.address;
                    } else {
                        this.hub.af.free(node.address);
                    }
                    node.address = -1;
                    this.size += node.size;
                } else {
                    this.size += 4;
                }
            } else if (this.size + node.size > 8190) {
                if (this.address >= 0 && this.ancestor != null) {
                    node.address = this.address;
                    this.address = -1;
                } else {
                    node.address = 0;
                }
                node.changed = true;
                this.size += 4;
            } else {
                this.size += node.size;
            }
            return;
        }
        int n7 = 0;
        int n8 = -1;
        int n9 = 8190;
        int n10 = 0;
        int n11 = this.first & 0x1F;
        int n12 = this.last & 0x1F;
        if (this.powerNode != null) {
            n7 = 1;
            n2 = this.powerNode.size;
            this.size = n2 > 127 ? n2 + 2 : n2 + 1;
        }
        if (this.count == 1) {
            node = this.descendant;
            n7 |= 1 << (node.mark & 0x1F);
            node.pack();
            if (node.address >= 0) {
                if (node.size <= 4095) {
                    if (this.address < 0) {
                        this.address = node.address;
                    } else {
                        this.hub.af.free(node.address);
                    }
                    node.address = -1;
                    n2 = node.size;
                } else {
                    n2 = 4;
                }
            } else {
                n2 = node.size;
            }
            this.size = n2 > 127 ? (this.size += n2 + 2) : (this.size += n2 + 1);
        } else {
            for (n10 = n11; n10 <= n12; ++n10) {
                node = this.posterity[n10];
                if (node == null) continue;
                n7 |= 1 << n10;
                node.pack();
                if (node.address >= 0) {
                    if (node.size <= 4095 && node.size < n9) {
                        n8 = n10;
                        n9 = node.size;
                    }
                    n2 = 4;
                } else {
                    n2 = node.size;
                }
                if (n2 > 127) {
                    this.size += n2 + 2;
                    continue;
                }
                this.size += n2 + 1;
            }
        }
        int n13 = 1;
        int n14 = 0x80 | this.nextType;
        int n15 = 255;
        for (n = 0; n < 4; ++n) {
            if ((n7 & n15) != 0) {
                ++n13;
                n14 |= 1 << n;
            }
            n15 <<= 8;
        }
        this.size += n13;
        this.block = new byte[n13];
        this.block[0] = (byte)n14;
        int n16 = 1;
        for (n = 0; n < 4; ++n) {
            n15 = n7 & 0xFF;
            if (n15 != 0) {
                this.block[n16++] = (byte)n15;
            }
            n7 >>>= 8;
        }
        while (n8 >= 0 && this.size - 2 + n9 <= 8190) {
            node = this.posterity[n8];
            this.size -= 4;
            if (this.address < 0) {
                this.address = node.address;
            } else {
                this.hub.af.free(node.address);
            }
            node.address = -1;
            this.size += n9;
            if (n9 > 127) {
                ++this.size;
            }
            n8 = -1;
            n9 = 8190;
            if (this.size > 4095) continue;
            for (n10 = n11; n10 <= n12; ++n10) {
                node = this.posterity[n10];
                if (node == null || node.address < 0 || node.size >= 4095 || node.size >= n9) continue;
                n9 = node.size;
                n8 = n10;
            }
        }
        while (this.size > 8190) {
            n2 = 0;
            if (this.count == 1) {
                node = this.descendant;
                n2 = node.size;
            } else {
                for (n10 = n11; n10 <= n12; ++n10) {
                    node = this.posterity[n10];
                    if (node == null || node.count == 0 || node.address >= 0 || node.size <= n2) continue;
                    n15 = n10;
                    n2 = node.size;
                }
                node = this.posterity[n15];
            }
            this.size -= n2;
            if (n2 > 127) {
                --this.size;
            }
            if (this.address >= 0 && this.ancestor != null) {
                node.address = this.address;
                this.address = -1;
            } else {
                node.address = 0;
            }
            node.changed = true;
            this.size += 4;
        }
    }

    void packPower() {
        this.powerNode = new Node(32);
        this.powerNode.hub = this.hub;
        Trace trace = new Trace(this.power, 31, 5);
        try {
            Node node = this.powerNode.setTrace(trace);
            this.powerNode.pack();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void jam(Node node) throws IOException {
        node.deploy();
        if (node.address >= 0) {
            if (this.address >= 0) {
                this.hub.af.free(node.address);
                node.address = -1;
            } else {
                this.address = node.address;
            }
        }
        if (node.count == 1 && node.first == node.notation) {
            this.jam(node.descendant);
            return;
        }
        if (!node.changed) {
            this.size = node.size;
            this.onset = node.onset;
            this.block = node.block;
        }
        this.count = node.count;
        this.changed = node.changed;
        this.nextType = node.nextType;
        this.first = node.first;
        this.last = node.last;
        this.descendant = node.descendant;
        this.posterity = node.posterity;
        if (this.count == 1) {
            this.descendant.ancestor = this;
        } else {
            int n = this.first & 0x1F;
            int n2 = this.last & 0x1F;
            for (int i = n; i <= n2; ++i) {
                if (this.posterity[i] == null) continue;
                this.posterity[i].ancestor = this;
            }
        }
    }

    void save() throws IOException {
        if (!this.changed) {
            return;
        }
        if (this.hub.af.bind == null) {
            this.hub.open();
        }
        this.hub.af.startSaving();
        if (this.address < 0) {
            this.address = this.hub.af.alloc();
        }
        this.pack();
        byte[] byArray = new byte[8192];
        int n = PN.writeSize(this.size, byArray, 0);
        this.save1(byArray, n);
        if (this.address == 0) {
            Int1 int1 = new Int1(0);
            n = PN.readSize(byArray, 0, int1);
            if ((n += int1.value) + 3 < 8192) {
                PN.writeAddress(282624, byArray, n);
            }
        }
        this.hub.af.write(byArray, this.address);
        this.hub.af.stopSaving();
    }

    void save1(byte[] byArray, int n) throws IOException {
        if (this.count == 0) {
            return;
        }
        if (this.onset > 0) {
            System.arraycopy(this.block, this.onset, byArray, n, this.size);
            this.block = byArray;
            this.onset = n;
            return;
        }
        System.arraycopy(this.block, 0, byArray, n, this.block.length);
        this.onset = n;
        n += this.block.length;
        this.block = byArray;
        if (this.count == 1 && this.powerNode == null) {
            Node node = this.descendant;
            while (node.count == 1 && node.size == 0) {
                node.changed = false;
                node = node.descendant;
            }
            if (node.address >= 0) {
                node.save3();
                PN.writeAddress(node.address, byArray, n);
            } else {
                node.save1(byArray, n);
            }
            this.changed = false;
            return;
        }
        if (this.powerNode != null) {
            n = this.powerNode.save2(byArray, n);
        }
        if (this.count == 1) {
            Node node = this.descendant;
            node.save2(byArray, n);
            this.changed = false;
            return;
        }
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        for (int i = n2; i <= n3; ++i) {
            Node node = this.posterity[i];
            if (node == null) continue;
            n = node.save2(byArray, n);
        }
        this.changed = false;
    }

    int save2(byte[] byArray, int n) throws IOException {
        if (this.address >= 0) {
            int n2 = 4;
            n = PN.writeSize(n2, byArray, n);
            this.save3();
            n = PN.writeAddress(this.address, byArray, n);
        } else {
            n = PN.writeSize(this.size, byArray, n);
            this.save1(byArray, n);
            n += this.size;
        }
        return n;
    }

    void save3() throws IOException {
        if (!this.changed) {
            return;
        }
        if (this.address == 0) {
            this.address = this.hub.af.alloc();
        }
        byte[] byArray = new byte[8192];
        int n = PN.writeSize(this.size, byArray, 0);
        this.save1(byArray, n);
        this.hub.af.write(byArray, this.address);
    }

    void ploy() {
        this.count = -1;
        this.descendant = null;
        this.posterity = null;
    }

    boolean store() throws IOException {
        if (this.count <= 0) {
            return false;
        }
        int n = this.first & 0x1F;
        int n2 = this.last & 0x1F;
        if (this != this.hub.node) {
            return this.store(n, n2);
        }
        this.save();
        if (this.count == 1) {
            this.descendant.ploy();
            return true;
        }
        for (int i = n; i <= n2; ++i) {
            if (this.posterity[i] == null) continue;
            this.posterity[i].ploy();
        }
        return true;
    }

    boolean store(int n, int n2) throws IOException {
        if (this.count <= 0 || n > (this.last & 0x1F) || n2 < (this.first & 0x1F)) {
            return false;
        }
        if (!this.changed) {
            if (this.count == 1) {
                this.descendant.store1();
            } else {
                for (int i = n; i <= n2; ++i) {
                    if (this.posterity[i] == null) continue;
                    this.posterity[i].store1();
                }
            }
            return true;
        }
        if (this.hub.af.bind == null) {
            this.hub.open();
        }
        this.hub.af.startSaving();
        if (this.hub.node.address < 0) {
            this.hub.node.address = this.hub.af.alloc();
        }
        this.pack();
        if (this.count == 1) {
            this.descendant.store1();
        } else {
            for (int i = n; i <= n2; ++i) {
                if (this.posterity[i] == null) continue;
                this.posterity[i].store1();
            }
        }
        this.hub.af.stopSaving();
        return true;
    }

    void store1() throws IOException {
        if (this.changed) {
            byte[] byArray;
            if (this.address >= 0) {
                if (this.address == 0) {
                    this.address = this.hub.af.alloc();
                }
                byArray = new byte[8192];
            } else {
                byArray = new byte[this.size + 2];
            }
            int n = PN.writeSize(this.size, byArray, 0);
            this.save1(byArray, n);
            if (this.address >= 0) {
                this.hub.af.write(byArray, this.address);
            }
        }
        this.ploy();
    }

    boolean restore() throws IOException {
        if (!this.changed) {
            return false;
        }
        if (this.address < 0) {
            return false;
        }
        this.changed = false;
        this.ploy();
        this.block = new byte[4];
        this.onset = 0;
        this.size = PN.writeAddress(this.address, this.block, 0);
        this.address = -1;
        return true;
    }

    boolean delete() throws IOException {
        this.ploy();
        this.count = 0;
        this.block = null;
        this.onset = 0;
        this.size = 0;
        this.address = -1;
        this.changed = false;
        return true;
    }

    Node getNextNode(int n, int n2, Node node, Trace trace) throws IOException {
        if (this.deploy() == 0) {
            throw new IndexOutOfBoundsException("Unexpected empty node. System error, please direct to TechCenter");
        }
        if (trace.next == null) {
            return this.nextNode(n, n2, node);
        }
        int n3 = trace.next.mark & 0x20;
        if (this.nextType < n3) {
            if (this.notation != trace.next.mark) {
                return this.nextNode(n, n2, node);
            }
            return this.getNextNode(n, n2, node, trace.next);
        }
        Node node2 = this.nextType > n3 ? this.getIndex(this.notation) : this.getIndex(trace.next.mark);
        if (node2 == null) {
            return this.nextNode(n, n2, node);
        }
        return node2.getNextNode(n, n2, node, trace.next);
    }

    Node nextNode(int n, int n2, Node node) throws IOException {
        Node node2;
        if (this.first <= n) {
            node2 = this.count == 1 ? this.descendant : this.posterity[this.first & 0x1F];
            if (node2.deploy() != 0) {
                if (node2.hasCriterion(n, n2)) {
                    return node2;
                }
                return node2.nextNode(n, n2, node);
            }
        } else {
            node2 = this;
        }
        while (node2 != node) {
            int n3 = node2.mark & 0x1F;
            node2 = node2.ancestor;
            if (node2.count <= 1) continue;
            int n4 = node2.last > n ? n & 0x1F : node2.last & 0x1F;
            while (++n3 <= n4) {
                if (node2.posterity[n3] == null) continue;
                node2 = node2.posterity[n3];
                node2.deploy();
                if (node2.hasCriterion(n, n2)) {
                    return node2;
                }
                return node2.nextNode(n, n2, node);
            }
        }
        return null;
    }

    Node lastNode(int n) throws IOException {
        Node node;
        if (this.first > n) {
            return this;
        }
        int n2 = this.first & 0x1F;
        if (this.last > n) {
            node = null;
            for (int i = n & 0x1F; i >= n2 && (node = this.posterity[i]) == null; --i) {
            }
        } else {
            node = this.count == 1 ? this.descendant : this.posterity[this.last & 0x1F];
        }
        if (node.deploy() == 0) {
            return null;
        }
        return node.lastNode(n);
    }

    Node freeAncestors() throws IOException {
        Node node = this;
        while (node.count == 0 && node.ancestor != null) {
            if (node.address >= 0) {
                this.hub.af.free(node.address);
                node.address = -1;
            }
            int n = node.mark;
            node = node.ancestor;
            node.clearMark(n);
        }
        return node;
    }

    boolean correlates(Node node) throws IOException {
        if (this.deploy() == 0 || node.deploy() == 0) {
            return true;
        }
        return this.nextType != 0 || node.nextType != 0 || this.notation == node.notation;
    }

    Node setCorrelating(Node node) throws IOException {
        if (this.correlates(node)) {
            return this;
        }
        Node node2 = new Node();
        this.setIndex(node.notation, node2);
        return node2;
    }

    Node get(Trace trace, Node node, int n, int n2, int n3, int n4, int n5) throws IOException {
        Node node2;
        if (!this.hasMark()) {
            return null;
        }
        if (trace == null || trace.next == null) {
            node2 = this;
        } else {
            node2 = this.getTrace(trace, n);
            if (node2 == null) {
                return null;
            }
        }
        if (node == null) {
            return node2.get(n, n5);
        }
        return node2.get(node, n, n2, n3, n4, n5);
    }

    boolean has(Trace trace, Node node, int n, int n2, int n3, int n4) throws IOException {
        Node node2;
        if (!this.hasMark()) {
            return false;
        }
        if (trace == null || trace.next == null) {
            node2 = this;
        } else {
            node2 = this.getTrace(trace, n);
            if (node2 == null) {
                return false;
            }
        }
        if (node == null) {
            return true;
        }
        return node2.has(node, n, n2, n3, n4);
    }

    boolean set(Trace trace, Node node, int n, int n2) throws IOException {
        this.deploy();
        Node node2 = trace == null || trace.next == null ? this : this.setTrace(trace);
        if (node == null) {
            return node2.setConcept();
        }
        return node2.set(node, n, n2);
    }

    boolean clear(Trace trace, Node node, int n, int n2, int n3) throws IOException {
        Node node2;
        if (!this.hasMark()) {
            return false;
        }
        if (trace == null || trace.next == null) {
            node2 = this;
        } else {
            node2 = this.getTrace(trace);
            if (node2 == null) {
                return false;
            }
        }
        boolean bl = node == null ? node2.clear(n, n3) : node2.clear(node, n, n2, n3);
        if (node2.count == 0) {
            this.clearTrace(trace);
        }
        if (this.count == 0 && this.address >= 0) {
            this.hub.af.free(this.address);
            this.address = -1;
        }
        return bl;
    }

    Node getConnect(int n) throws IOException {
        if (!this.hasConnect(n)) {
            return null;
        }
        return this.getIndex(n);
    }

    Node getConnect(int n, Trace trace, Node node, int n2, int n3, int n4, int n5, int n6) throws IOException {
        Node node2 = this.getConnect(n);
        if (node2 == null) {
            return null;
        }
        return node2.get(trace, node, n2, n3, n4, n5, n6);
    }

    boolean hasNotation(int n) throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        return this.first <= n;
    }

    boolean hasConcept() throws IOException {
        return this.hasMark(59);
    }

    boolean hasConcept(int n) throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        return this.last > n || n == 59 && this.hasMark(59);
    }

    boolean hasConnect(int n) throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        if (this.last < n) {
            return false;
        }
        Node node = this.getIndex(n);
        return node != null && node.deploy() != 0;
    }

    boolean hasConnect() throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        if (this.last < 56) {
            return false;
        }
        if (this.count > 1) {
            for (int i = 56; i <= 62; ++i) {
                Node node = this.posterity[i & 0x1F];
                if (node == null || node.deploy() == 0) continue;
                return true;
            }
        } else {
            return this.descendant.deploy() != 0;
        }
        return false;
    }

    boolean hasConnect(int n, Trace trace, Node node, int n2, int n3, int n4, int n5) throws IOException {
        Node node2 = this.getConnect(n);
        if (node2 == null) {
            return false;
        }
        return node2.has(trace, node, n2, n3, n4, n5);
    }

    boolean setConcept() throws IOException {
        if (this.hasConcept()) {
            return false;
        }
        this.setMark(59, new Node());
        this.setChange();
        return true;
    }

    boolean setConnect(int n, Trace trace, Node node, int n2, int n3) throws IOException {
        Node node2 = this.getMark(n);
        if (node2 == null) {
            node2 = new Node();
            this.setMark(n, node2);
        }
        return node2.set(trace, node, n2, n3);
    }

    boolean clearConcept() throws IOException {
        if (!this.hasConcept()) {
            return false;
        }
        Node node = this.getIndex(59);
        if (node.deploy() != 0) {
            node.clearMark();
            if (node.address >= 0) {
                this.hub.af.free(node.address);
                node.address = -1;
            }
        }
        this.clearIndex(59);
        this.setChange();
        return true;
    }

    boolean clearConnect() throws IOException {
        int n;
        int n2;
        boolean bl = false;
        if (this.deploy() == 0 || this.last < 56) {
            return false;
        }
        if (this.count == 1) {
            Node node = this.getIndex(this.last);
            bl = node.clearMark();
            if (node.address >= 0) {
                this.hub.af.free(node.address);
                node.address = -1;
            }
            if (this.last != 59) {
                return this.clearMark(this.last);
            }
            return bl;
        }
        if (this.first < 56) {
            n2 = 24;
        } else {
            this.first = 0;
            n2 = this.first & 0x1F;
        }
        int n3 = this.last & 0x1F;
        int n4 = 27;
        this.last = 0;
        for (n = n2; n <= n3; ++n) {
            Node node = this.posterity[n];
            if (node == null) continue;
            bl |= node.clearMark();
            if (node.address >= 0) {
                this.hub.af.free(node.address);
                node.address = -1;
            }
            if (n == n4) {
                this.last = 59;
                continue;
            }
            --this.count;
            this.posterity[n] = null;
            bl = true;
        }
        if (this.count == 0) {
            this.posterity = null;
            return bl;
        }
        if (this.count == 1) {
            if (this.first == 0) {
                this.first = this.last;
            } else {
                this.last = this.first;
            }
            this.descendant = this.posterity[this.last & 0x1F];
            this.posterity = null;
            return bl;
        }
        if (this.last != 0) {
            return bl;
        }
        n = n2 - 1;
        while (this.posterity[n] == null) {
            --n;
        }
        this.last = 0x20 | n;
        return bl;
    }

    boolean clearConnect(int n) throws IOException {
        Node node = this.getConnect(n);
        if (node == null) {
            return false;
        }
        node.clearMark();
        if (node.address >= 0) {
            this.hub.af.free(node.address);
            node.address = -1;
        }
        if (n != 59) {
            return this.clearMark(n);
        }
        return true;
    }

    boolean clearConnect(int n, Trace trace, Node node, int n2, int n3, int n4) throws IOException {
        Node node2 = this.getConnect(n);
        if (node2 == null) {
            return false;
        }
        node2.clear(trace, node, n2, n3, n4);
        if (node2.count == 0 && n != 59) {
            this.clearMark(n);
        }
        return true;
    }

    Node seekKeyNode(int n) throws IOException {
        if (this.hasConcept(n) || this.count > 1) {
            return this;
        }
        if (this.count == 0) {
            return null;
        }
        return this.descendant.seekKeyNode(n);
    }

    void upperPower() {
        if (this.mark >= 57 || this.ancestor == null) {
            this.restorePower();
            this.powerNode = null;
            ++this.power;
        }
        if (this.mark <= 57 && this.ancestor != null) {
            this.ancestor.upperPower();
        }
    }

    void lowerPower() {
        if (this.mark >= 57 || this.ancestor == null) {
            this.restorePower();
            this.powerNode = null;
            --this.power;
        }
        if (this.mark <= 57 && this.ancestor != null) {
            this.ancestor.lowerPower();
        }
    }

    long restorePower() {
        if (this.power > (long)0) {
            return this.power;
        }
        if (this.powerNode == null) {
            return 0L;
        }
        Node node = this.powerNode;
        try {
            while (node.deploy() != 0) {
                node = node.descendant;
                this.power = this.power << 5 | (long)node.mark;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            long l = -1L;
            return l;
        }
        return this.power;
    }

    void print() throws IOException {
        this.print(new PrintWriter(System.out));
    }

    void print(PrintWriter printWriter) throws IOException {
        printWriter.print("Node=");
        this.printAncestor(printWriter);
        printWriter.println();
        this.printDescendants(printWriter, 0, 1000);
        printWriter.println();
        printWriter.flush();
    }

    void printAncestor(PrintWriter printWriter) throws IOException {
        if (this.ancestor != null) {
            this.ancestor.printAncestor(printWriter);
            printWriter.print(':');
        }
        printWriter.print(this.mark);
    }

    int printDescendants(PrintWriter printWriter, int n, int n2) throws IOException {
        int n3 = this.first & 0x1F;
        int n4 = this.last & 0x1F;
        if (n > 80 || n2 <= 0) {
            return n2;
        }
        String string = String.valueOf(this.mark);
        if (n != 0) {
            printWriter.print(string);
            n += string.length();
            n2 -= string.length();
        }
        if (this.deploy() <= 0) {
            return n2;
        }
        printWriter.print(':');
        ++n;
        --n2;
        boolean bl = true;
        if (this.descendant != null) {
            n2 = this.descendant.printDescendants(printWriter, n, n2);
        } else {
            for (int i = n3; i <= n4; ++i) {
                if (this.posterity[i] == null) continue;
                if (bl) {
                    bl = false;
                } else {
                    n2 = this.printLineSpace(printWriter, n, n2);
                }
                n2 = this.posterity[i].printDescendants(printWriter, n, n2);
            }
        }
        return n2;
    }

    int printLineSpace(PrintWriter printWriter, int n, int n2) throws IOException {
        printWriter.println();
        n2 -= n;
        for (int i = 0; i < n; ++i) {
            printWriter.print(' ');
        }
        return n2;
    }

    Node seekClassDefnNode() throws IOException {
        if (this.hasConcept(57)) {
            return this;
        }
        if (this.count == 1) {
            Node node = this.descendant.seekClassDefnNode();
            if (node == null && this.hasIndex(57)) {
                return this;
            }
            return node;
        }
        return null;
    }

    int depends(Node node) {
        if (this == node) {
            return 0;
        }
        if (this.hub != node.hub) {
            String string = this.hub.getAbsolutePath();
            String string2 = node.hub.getAbsolutePath();
            if (string.length() == 0 || string2.length() == 0) {
                return -1;
            }
            if (!string.equals(string2)) {
                return -1;
            }
        }
        Trace trace = this.defTrace();
        Trace trace2 = node.defTrace();
        Concept.normal(trace);
        Concept.normal(trace2);
        Trace trace3 = new Trace();
        Trace trace4 = new Trace();
        if (!trace.equals(trace2, trace3, trace4)) {
            return -1;
        }
        if (trace3.next == trace4.next) {
            return 0;
        }
        if (trace4.next != null) {
            return 1;
        }
        return 2;
    }

    Trace defTrace() {
        return this.defTrace(null);
    }

    Trace defTrace(Node node) {
        Trace trace;
        Trace trace2 = new Trace();
        Node node2 = this;
        while (node2 != node) {
            trace2.mark = node2.mark;
            node2 = node2.ancestor;
            trace = trace2;
            trace2 = new Trace();
            trace2.next = trace;
        }
        if (trace2.next != null && trace2.next.mark <= 31) {
            trace2.mark = node2.notation;
            trace = trace2;
            trace2 = new Trace();
            trace2.next = trace;
        }
        return trace2;
    }

    Node get(int n, int n2) throws IOException {
        Get get = new Get(this, n, n2);
        return get.nResult;
    }

    Node get(Node node, int n, int n2, int n3, int n4, int n5) throws IOException {
        Get get = new Get(this, node, n, n2, n3, n4, n5);
        return get.nResult;
    }

    boolean has(Node node, int n, int n2, int n3, int n4) throws IOException {
        Has has = new Has(this, node, n, n2, n3, n4);
        return has.bResult;
    }

    boolean set(Node node, int n, int n2) throws IOException {
        Set set = new Set(this, node, n, n2);
        return set.bResult;
    }

    boolean clear(int n, int n2) throws IOException {
        Clear clear = new Clear(this, n, n2);
        return clear.bResult;
    }

    boolean clear(Node node, int n, int n2, int n3) throws IOException {
        Clear clear = new Clear(this, node, n, n2, n3);
        return clear.bResult;
    }

    Node getConnection(int n, int n2, PList pList) throws IOException {
        GetConnection getConnection = new GetConnection(this, n, n2, pList);
        return getConnection.nResult;
    }

    Node getConnection(Node node, int n, int n2, int n3, PList pList) throws IOException {
        GetConnection getConnection = new GetConnection(this, node, n, n2, n3, pList);
        if (getConnection.nResult.count == 0) {
            return null;
        }
        return getConnection.nResult;
    }

    PList getConnectionList(int n, int n2, PList pList) throws IOException {
        GetConnectionList getConnectionList = new GetConnectionList(this, n, n2, pList);
        return getConnectionList.lResult;
    }

    PList getConnectionList(Node node, int n, int n2, int n3, PList pList) throws IOException {
        GetConnectionList getConnectionList = new GetConnectionList(this, node, n, n2, n3, pList);
        return getConnectionList.lResult;
    }

    boolean hasConnection(int n, int n2, PList pList) throws IOException {
        HasConnection hasConnection = new HasConnection(this, n, n2, pList);
        return hasConnection.bResult;
    }

    boolean hasConnection(Node node, int n, int n2, int n3, PList pList) throws IOException {
        HasConnection hasConnection = new HasConnection(this, node, n, n2, n3, pList);
        return hasConnection.bResult;
    }

    boolean setCConnection(int n, int n2, PList pList) throws IOException {
        SetCConnection setCConnection = new SetCConnection(this, n, n2, pList);
        return setCConnection.bResult;
    }

    boolean setCConnection(Node node, int n, int n2, int n3, PList pList) throws IOException {
        SetCConnection setCConnection = new SetCConnection(this, node, n, n2, n3, pList);
        return setCConnection.bResult;
    }

    boolean setConnection(Node node, int n, int n2, PList pList) throws IOException {
        SetConnection setConnection = new SetConnection(this, node, n, n2, pList);
        return setConnection.bResult;
    }

    boolean clearConnection(int n, int n2, PList pList) throws IOException {
        ClearConnection clearConnection = new ClearConnection(this, n, n2, pList);
        return clearConnection.bResult;
    }

    boolean clearConnection(Node node, int n, int n2, int n3, PList pList) throws IOException {
        ClearConnection clearConnection = new ClearConnection(this, node, n, n2, n3, pList);
        return clearConnection.bResult;
    }

    Node getBy(int n, int n2, PList pList) throws IOException {
        GetBy getBy = new GetBy(this, n, n2, pList);
        return getBy.nResult;
    }

    Node getBy(Node node, int n, int n2, int n3, PList pList) throws IOException {
        GetBy getBy = new GetBy(this, node, n, n2, n3, pList);
        return getBy.nResult;
    }

    long power(int n, int n2) throws IOException {
        GetPower getPower = new GetPower(this, n, n2);
        return getPower.lResult;
    }

    long power(Node node, int n, int n2, int n3) throws IOException {
        GetPower getPower = new GetPower(this, node, n, n2, n3);
        return getPower.lResult;
    }

    boolean extendClass(boolean bl) throws IOException {
        ExtendClass extendClass = new ExtendClass(bl, this);
        return extendClass.bResult;
    }

    boolean extendClass(boolean bl, Node node, int n, int n2) throws IOException {
        ExtendClass extendClass = new ExtendClass(bl, this, node, n, n2);
        return extendClass.bResult;
    }

    boolean hasCriterion(Node node, int n, int n2, int n3) throws IOException {
        if (!this.hasCriterion(n, n3)) {
            return false;
        }
        if (!node.hasCriterion(n, n3)) {
            return false;
        }
        return this.hasCriterion1(node, n, n2, n3);
    }

    boolean hasCriterion(int n, int n2) throws IOException {
        if (!this.hasConcept(56)) {
            return false;
        }
        if (n2 == -1) {
            return true;
        }
        if (!this.hasConcept(n)) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        if (n == 56) {
            return true;
        }
        return !this.hasConnect(57);
    }

    boolean hasCriterion1(Node node, int n, int n2, int n3) throws IOException {
        if (n == 56) {
            return true;
        }
        if ((n2 & 0x40) != 0) {
            return true;
        }
        if (n3 == -1) {
            return true;
        }
        return this.hasCriterion1(node, n2);
    }

    public boolean hasCriterion1(Node node, int n) throws IOException {
        if (node.hasConnect(57)) {
            return true;
        }
        return (n & 0x40) != 0;
    }

    boolean hasGetCriterion(Node node, int n, int n2, int n3, int n4, int n5) throws IOException {
        if (!node.hasCriterion(n, n5) || !this.hasCriterion(n, n4)) {
            return false;
        }
        if ((n3 & 0x3F) == 57 && (n2 & 0x3F) == 57) {
            return this.hasCriterion1(node, n, n3, n5) && node.hasCriterion1(this, n, n2, n4);
        }
        if ((n3 & 0x3F) == 57) {
            return this.hasCriterion1(node, n, n3, n5);
        }
        if ((n2 & 0x3F) == 57) {
            return node.hasCriterion1(this, n, n2, n4);
        }
        return this.hasCriterion1(node, n, n3, n5) || node.hasCriterion1(this, n, n2, n4);
    }

    Node seekTrace(Trace trace) throws IOException {
        Node node = this;
        Trace trace2 = trace.next;
        while (trace2 != null) {
            if (node.deploy() == 0) {
                return node;
            }
            Node node2 = node.getMark(trace2.mark);
            if (node2 == null) {
                return node;
            }
            node = node2;
            if (trace2.mark == 36 && trace2.next != null) {
                int n;
                int n2 = node.getDegree();
                if (n2 < (n = this.getTraceDegree(trace2))) {
                    if ((trace2 = this.getTraceFooting(trace2, n - n2)) == null) {
                        return node;
                    }
                } else if (n2 > n) {
                    node2 = node.getFooting(n2 - n);
                    if (node2 == null) {
                        return null;
                    }
                    node = node2;
                }
            }
            trace2 = trace2.next;
        }
        return node;
    }
}

