/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.Trace;

public class PList {
    Element first;
    Element last;
    Element current;
    boolean initiate;
    int commonType;
    int size;

    public PList add(Object object) {
        return this.add(0, object);
    }

    public PList add(int n, Object object) {
        Element element = new Element(this, n, object);
        if (this.last == null) {
            this.first = element;
        } else {
            element.back = this.last;
            this.last.next = element;
        }
        this.last = element;
        ++this.size;
        return this;
    }

    public PList add(Trace trace, Object object) {
        Element element = new Element(this, trace, object);
        if (this.last == null) {
            this.first = element;
        } else {
            element.back = this.last;
            this.last.next = element;
        }
        this.last = element;
        ++this.size;
        return this;
    }

    public PList insert(Object object) {
        return this.insert(0, object);
    }

    public PList insert(int n, Object object) {
        Element element = new Element(this, n, object);
        if (this.current == null) {
            element.next = this.first;
            if (this.first != null) {
                this.first.back = element;
            }
            this.first = element;
            return this;
        }
        if (this.current == this.first) {
            this.first = element;
        } else {
            element.back = this.current.back;
            element.back.next = element;
        }
        element.next = this.current;
        this.current.back = element;
        ++this.size;
        return this;
    }

    public PList insert(Trace trace, Object object) {
        Element element = new Element(this, trace, object);
        if (this.current == null) {
            element.next = this.first;
            if (this.first != null) {
                this.first.back = element;
            }
            this.first = element;
            return this;
        }
        if (this.current == this.first) {
            this.first = element;
        } else {
            element.back = this.current.back;
            element.back.next = element;
        }
        element.next = this.current;
        this.current.back = element;
        ++this.size;
        return this;
    }

    public PList update(Object object) {
        if (this.current != null) {
            this.current.object = object;
        }
        return this;
    }

    public PList update(int n, Object object) {
        if (this.current != null) {
            this.current.object = object;
            this.current.types = new Trace(n);
        }
        return this;
    }

    public PList update(Trace trace, Object object) {
        if (this.current != null) {
            this.current.object = object;
            this.current.types = trace;
        }
        return this;
    }

    public PList remove() {
        if (this.current == null) {
            return this;
        }
        if (this.first == this.last) {
            this.first = null;
            this.current = null;
            this.last = null;
        } else if (this.current == this.first) {
            this.first = this.current.next;
            if (this.first != null) {
                this.first.back = null;
            }
            this.current = null;
            this.initiate = true;
        } else if (this.current == this.last) {
            this.last = this.current.back;
            this.last.next = null;
            this.current = this.last;
        } else {
            this.current.back.next = this.current.next;
            this.current.next.back = this.current.back;
            this.current = this.current.back;
        }
        --this.size;
        return this;
    }

    public boolean hasNext() {
        return this.current != null && this.current.next != null || this.initiate && this.first != null;
    }

    public boolean hasBack() {
        return this.current != null && this.current.back != null;
    }

    public boolean hasCurrent() {
        return this.current != null;
    }

    public Object getFirst() {
        this.initiate = false;
        this.current = this.first;
        if (this.current == null) {
            return null;
        }
        return this.current.object;
    }

    public Object getLast() {
        this.initiate = false;
        this.current = this.last;
        if (this.current == null) {
            return null;
        }
        return this.current.object;
    }

    public Object getNext() {
        if (this.current != null) {
            this.current = this.current.next;
        } else if (this.initiate) {
            this.current = this.first;
            this.initiate = false;
        }
        if (this.current == null) {
            return null;
        }
        return this.current.object;
    }

    public Object getBack() {
        if (this.current != null) {
            this.current = this.current.back;
            if (this.current == null) {
                this.initiate = true;
            } else {
                return this.current.object;
            }
        }
        return null;
    }

    public Object getCurrent() {
        if (this.current == null) {
            return null;
        }
        return this.current.object;
    }

    public PList update(PList pList) {
        while (this.hasCurrent() && pList.hasCurrent()) {
            Object object = pList.getCurrent();
            Trace trace = pList.getTypes();
            this.update(trace, object);
            this.getNext();
            pList.getNext();
        }
        return this;
    }

    public PList insert(PList pList) {
        if (!pList.hasCurrent()) {
            return this;
        }
        while (pList.hasCurrent()) {
            Object object = pList.getCurrent();
            Trace trace = pList.getTypes();
            this.insert(trace, object);
            pList.getNext();
        }
        return this;
    }

    public PList addList(PList pList) {
        while (pList.hasCurrent()) {
            Object object = pList.getCurrent();
            Trace trace = pList.getTypes();
            this.add(trace, object);
            pList.getNext();
        }
        return this;
    }

    public PList removeAll() {
        this.first = null;
        this.last = null;
        this.current = null;
        this.size = 0;
        return this;
    }

    public PList removeNextAll() {
        if (this.initiate) {
            this.first = null;
            this.last = null;
            this.size = 0;
            return this;
        }
        if (this.current == null) {
            return this;
        }
        int n = this.sizeNext();
        this.size -= n;
        this.current.next = null;
        this.last = this.current;
        return this;
    }

    public PList removeBackAll() {
        if (this.current == null) {
            return this;
        }
        int n = this.sizeBack();
        this.size -= n;
        this.current.back = null;
        this.first = this.current;
        return this;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public boolean has() {
        return !this.isEmpty();
    }

    public boolean hasOne() {
        if (this.first == null) {
            return false;
        }
        return this.first == this.last;
    }

    public void init() {
        this.current = null;
        this.initiate = true;
    }

    public Object clone() {
        Element element;
        PList pList = new PList();
        pList.initiate = this.initiate;
        if (this.current != null) {
            element = this.first;
            while (element != this.current) {
                pList.add((Trace)element.types.clone(), element.object);
                element = element.next;
            }
            pList.add((Trace)element.types.clone(), element.object);
            pList.current = pList.last;
        } else if (this.first != null) {
            element = this.first;
            pList.add((Trace)element.types.clone(), element.object);
        } else {
            return pList;
        }
        element = element.next;
        while (element != null) {
            pList.add((Trace)element.types.clone(), element.object);
            element = element.next;
        }
        return pList;
    }

    public PList cloneNext() {
        PList pList = new PList();
        pList.initiate = this.initiate;
        if (this.current == null && !this.initiate) {
            return pList;
        }
        Element element = this.current != null ? this.current.next : this.first;
        while (element != null) {
            pList.add(element.types, element.object);
            element = element.next;
        }
        return pList;
    }

    public int getType() {
        if (this.current == null) {
            return 0;
        }
        return this.current.types.mark;
    }

    public void setType(int n) {
        if (this.current == null) {
            return;
        }
        this.current.types.mark = n;
    }

    public Trace getTypes() {
        if (this.current == null) {
            return null;
        }
        return this.current.types;
    }

    public void setTypes(Trace trace) {
        if (this.current == null) {
            return;
        }
        this.current.types = trace;
    }

    public int getType(int n) {
        if (this.current == null || n < 0) {
            return 0;
        }
        Trace trace = this.current.types;
        for (int i = 0; i < n && trace != null; ++i) {
            trace = trace.next;
        }
        return trace.mark;
    }

    public void setType(int n, int n2) {
        if (this.current == null || n < 0) {
            return;
        }
        Trace trace = this.current.types;
        for (int i = 0; i < n && trace != null; ++i) {
            trace = trace.next;
        }
        trace.mark = n2;
    }

    public int size() {
        return this.size;
    }

    public int sizeNext() {
        int n = 0;
        if (this.current == null) {
            return n;
        }
        Element element = this.current.next;
        while (element != null) {
            ++n;
            element = element.next;
        }
        return n;
    }

    public int sizeBack() {
        int n = 0;
        if (this.current == null) {
            return n;
        }
        Element element = this.current.back;
        while (element != null) {
            ++n;
            element = element.back;
        }
        return n;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        if (this.size == 0) {
            return objectArray;
        }
        Element element = this.first;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = element.object;
            element = element.next;
        }
        return objectArray;
    }

    class Element {
        Object object;
        Trace types;
        Element back;
        Element next;

        Element(PList pList, int n, Object object) {
            this.object = object;
            this.types = new Trace(n);
        }

        Element(PList pList, Trace trace, Object object) {
            this.object = object;
            this.types = trace;
        }
    }
}

