/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Parser.Fielder;
import Sav.Processor.Association;
import Sav.Processor.Concept;
import Sav.Processor.Long1;
import Sav.Processor.Memory;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Z.Copula;
import Sav.Z.DataBase;
import Sav.Z.Error;
import Sav.Z.Failure;
import Sav.Z.Lexis;
import Sav.Z.Procedure;
import Sav.Z.Session;
import Sav.Z.Statement;
import Sav.Z.ZException;
import java.io.File;
import java.io.IOException;

class Expression
implements Lexis {
    Statement stm;
    int index;
    String text;
    int begin;
    int end;
    Copula copula;
    PList list = new PList();
    String type;
    File file;
    Expression eContext;
    int feature;
    Association ass;
    Concept cnc;

    void affect(Expression expression) {
        this.stm = expression.stm;
        this.index = expression.index;
        this.text = expression.text;
        this.begin = expression.begin;
        this.end = expression.end;
        this.copula = expression.copula;
        this.list = expression.list;
        this.type = expression.type;
        this.file = expression.file;
        this.eContext = expression.eContext;
        this.feature = expression.feature;
        this.ass = expression.ass;
        this.cnc = expression.cnc;
    }

    Expression() {
    }

    Expression(Statement statement) throws ZException {
        this.stm = statement;
        this.text = statement.text;
        try {
            this.equip();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Error(exception, statement, this.begin);
            throw new ZException(exception.toString());
        }
    }

    void equip() {
        int n;
        char c = '\u0000';
        int n2 = this.stm.end;
        this.begin = this.stm.pos;
        this.begin = Fielder.passSpace(this.stm.text, this.begin, n2);
        if (this.begin != this.stm.pos) {
            this.stm.pos = this.begin;
        }
        this.end = this.begin;
        this.index = -10;
        if (this.begin == n2) {
            return;
        }
        c = this.text.charAt(this.begin);
        int n3 = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' ? -1 : "$*#\"' {[(}])^:/\\| ~= ,;<>".indexOf(c);
        if (n3 > 5) {
            if (n3 == 12 && this.stm.copula != null && this.stm.copula.index == n3) {
                this.warnErr1(String.valueOf(String.valueOf(new StringBuffer("Redundant or duplicate ").append(c).append(" symbol"))));
                ++this.end;
                this.stm.pos = this.end;
                this.equip();
            }
            return;
        }
        ++this.end;
        char c2 = this.end == n2 ? (char)';' : (char)this.text.charAt(this.end);
        if (n3 == 0) {
            n = "$*#\"' {[(}])^:/\\| ~= ,;<>".indexOf(c2);
            if (c2 >= '0' && c2 <= '9' || c2 == '.') {
                n3 = -2;
            } else if (c2 == '*') {
                n3 = -3;
            } else if (n > 0 && c2 != '\"' && c2 != '\'') {
                this.warnErr0("Unrecognized '$' specification");
                this.stm.pos = ++this.begin;
                this.equip();
                return;
            }
        }
        switch (n3) {
            case -3: {
                this.index = 4;
                this.copula = new Copula(this.stm.text, this.begin, this.index, '$');
                this.stm.pos = this.end;
                return;
            }
            case -2: {
                int n4 = 0;
                while (this.end < n2) {
                    c2 = this.text.charAt(this.end);
                    if (c2 == '.') {
                        ++n4;
                    }
                    if (!(c2 >= '0' && c2 <= '9' || c2 == '.' && n4 <= 1)) break;
                    ++this.end;
                }
                this.index = 4;
                this.copula = new Copula(this.stm.text, this.begin, this.index, '\u0000');
                this.stm.pos = this.end;
                return;
            }
            case -1: {
                while (this.end < n2 && (c2 = (char)this.text.charAt(this.end)) > ' ' && (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || (n = "$*#\"' {[(}])^:/\\| ~= ,;<>".indexOf(c2)) < 0)) {
                    ++this.end;
                }
                this.index = 4;
                this.copula = c == '$' ? new Copula(this.stm.text, this.begin, this.index, '$') : new Copula(this.stm.text, this.begin, this.index, '\u0000');
                this.stm.pos = this.end;
                return;
            }
            case 0: {
                while (this.end < n2) {
                    c2 = this.text.charAt(this.end);
                    n = "$*#\"' {[(}])^:/\\| ~= ,;<>".indexOf(c2);
                    if ((n >= 0 || c2 <= ' ') && c2 != ' ') {
                        if (c2 != '\"' && c2 != 39) break;
                        this.end = Fielder.passQuote(this.text, this.end, c2);
                        break;
                    }
                    ++this.end;
                }
                if (this.end < n2 && (c2 = (char)this.text.charAt(this.end)) == '*') {
                    ++this.end;
                }
                this.index = 0;
                this.copula = new Copula(this.stm.text, this.begin, this.index, '$');
                this.stm.pos = this.end;
                return;
            }
            case 1: {
                this.index = 1;
                this.copula = new Copula(this.stm.text, this.begin, this.index, '*');
                this.stm.pos = this.end;
                return;
            }
            case 2: {
                while (this.end < n2 && (c2 = (char)this.text.charAt(this.end)) >= '0' && c2 <= '9') {
                    ++this.end;
                }
                this.index = 2;
                this.copula = new Copula(this.stm.text, this.begin, this.index, '#');
                this.stm.pos = this.end;
                return;
            }
            case 3: 
            case 4: {
                this.end = Fielder.passQuote(this.text, this.begin, c);
                if (this.end == n2 && this.text.charAt(this.end - 1) != c) {
                    this.warnErr0(String.valueOf(String.valueOf(new StringBuffer("Unclosed ").append(c).append(" left quote"))));
                    this.stm.pos = ++this.begin;
                    this.equip();
                    return;
                }
                this.index = n3;
                this.copula = new Copula(this.stm.text, this.begin, this.index, c);
                this.stm.pos = this.end;
                return;
            }
        }
    }

    Expression(Statement statement, int n, int n2) {
        this.stm = statement;
        this.text = statement.text;
        this.begin = n;
        this.end = n;
        this.index = n2;
    }

    Expression(Statement statement, Copula copula, Expression expression) {
        this.stm = statement;
        this.text = statement.text;
        this.add(copula, expression);
    }

    Expression(Statement statement, Expression expression, Copula copula, Expression expression2) {
        this.stm = statement;
        this.text = statement.text;
        this.add(expression, copula, expression2);
    }

    void add(Copula copula, Expression expression) {
        this.begin = expression.begin;
        this.end = expression.end;
        this.copula = copula;
        this.index = copula.index;
        this.list.add(copula.look, (Object)expression);
    }

    void add(Expression expression, Copula copula, Expression expression2) {
        this.begin = expression.begin;
        this.end = expression2.end;
        this.copula = copula;
        this.index = copula.index;
        this.list.add(expression);
        this.list.add(copula.look, (Object)expression2);
    }

    void insert(Expression expression) {
        this.begin = expression.begin;
        this.list.getFirst();
        this.list.insert(expression);
    }

    void construe(Expression expression, int n) throws ZException {
        try {
            this.construe1(expression, n);
        }
        catch (ZException zException) {
            throw zException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Error(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    void construe1(Expression expression, int n) throws IOException {
        switch (this.index) {
            case -10: {
                this.eContext = expression;
                this.feature = n;
                break;
            }
            case 0: {
                this.construeSpecific(expression, n);
                break;
            }
            case 5: {
                this.construeSpace(expression, n);
                break;
            }
            case 6: {
                this.construeBrace(expression, n);
                break;
            }
            case 7: {
                this.construeBracket(expression, n);
                break;
            }
            case 8: {
                this.construeParenthesis(expression, n);
                break;
            }
            case 11: {
                this.construeParenthesisTerm(expression, n);
                break;
            }
            case 12: {
                this.construeRange(expression, n);
                break;
            }
            case 13: {
                this.construeColon(expression, n);
                break;
            }
            case 14: {
                this.construeDivide(expression, n);
                break;
            }
            case 15: {
                this.construeLeftSlash(expression, n);
                break;
            }
            case 16: {
                this.construeRightSlash(expression, n);
                break;
            }
            case 17: {
                this.construeExtraction(expression, n);
                break;
            }
            case 20: {
                this.construeDeclaration(expression, n);
                break;
            }
            case 18: 
            case 19: {
                if ((n & 0x80) == 0) {
                    this.construeEquality(expression, n);
                    break;
                }
                this.construeAssignement(expression, n);
                break;
            }
            case 21: {
                this.construeComma(expression, n);
            }
        }
        if (this.list.hasOne() && (this.index > 11 || this.index == 5)) {
            Expression expression2 = (Expression)this.list.getFirst();
            if (expression2.index == -10) {
                this.index = -10;
            } else {
                this.affect(expression2);
            }
        } else if (this.list.isEmpty()) {
            if (this.index == -4) {
                this.copula.look = (char)40;
                this.list.add(new Expression(this.stm, this.end, -10));
                this.stm.proc = new Procedure(this);
                this.stm.proc.construe();
            } else if (this.index >= 5) {
                this.index = -10;
            }
        }
    }

    void construeSpecific(Expression expression, int n) {
        Concept concept;
        Concept concept2;
        boolean bl;
        int n2;
        int n3;
        String string;
        int n4;
        this.eContext = expression;
        this.feature = n;
        int n5 = this.begin + 1;
        if (this.text.charAt(n5) != '\"' && this.text.charAt(n5) != '\'') {
            for (n4 = n5; n4 < this.end && this.text.charAt(n4) != '\"' && this.text.charAt(n4) != '\'' && this.text.charAt(n4) != ' ' && this.text.charAt(n4) != '*'; ++n4) {
            }
            string = this.text.substring(n5, n4);
        } else {
            string = "";
            n4 = n5;
        }
        Integer n6 = (Integer)Session.hTypes.get(string);
        if (n6 != null) {
            this.index = n6;
            while (n4 < this.end && this.text.charAt(n4) == ' ') {
                ++n4;
            }
            n3 = n4;
        } else {
            n3 = n5;
        }
        if (this.text.charAt(this.end - 1) == '*') {
            n2 = this.end - 1;
            bl = true;
        } else {
            n2 = this.end;
            bl = false;
        }
        if (this.text.charAt(n2 - 1) == '\"' || this.text.charAt(n2 - 1) == '\'') {
            --n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n4 = n3; n4 < n2; ++n4) {
            char c = this.text.charAt(n4);
            if (c != '\"' && c != '\'' && c != ' ') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                ++n4;
                while (n4 < n2 && (c = this.text.charAt(n4)) == ' ') {
                    ++n4;
                }
                if (n4 == n2) break;
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append(' ');
            }
            if (c == '\"' || c == '\'') {
                ++n4;
                while (n4 < n2) {
                    stringBuffer.append(this.text.charAt(n4));
                    ++n4;
                }
                break;
            }
            stringBuffer.append(this.text.charAt(n4));
        }
        String string2 = stringBuffer.toString();
        if (this.index < 0) {
            concept2 = new Concept(-this.index);
            this.type = Session.types[-this.index];
        } else {
            concept2 = null;
        }
        this.cnc = concept = new Concept(string2);
        Concept concept3 = null;
        Concept concept4 = null;
        try {
            if (bl) {
                if (concept2 == null) {
                    this.stm.ss.spec.con(61);
                    this.stm.ss.spec.see(concept);
                    concept3 = this.stm.ss.spec.getFirst(56);
                    if (concept3 != null) {
                        if (this.stm.ss.spec.getNext(56) != null) {
                            this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Ambiguous specific name ").append(string2).append("*"))), n3);
                            this.cnc = concept3;
                        }
                        this.stm.ss.spec.con(concept3).con(61);
                        concept4 = this.stm.ss.spec.getFirst(56);
                        if (this.stm.ss.spec.getNext(56) != null) {
                            this.warnErr("Ambiguous specific type", this.begin + 1);
                            this.type = Session.types[concept4.toNumber()];
                        }
                    }
                } else {
                    this.stm.ss.spec.con(57).con(concept2);
                    if (this.stm.ss.spec.hasConnect(57)) {
                        concept4 = concept2;
                        this.stm.ss.spec.con(57);
                        this.stm.ss.spec.see(concept);
                        concept3 = this.stm.ss.spec.getFirst(56);
                        if (concept3 != null && this.stm.ss.spec.getNext(56) != null) {
                            this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Ambiguous specific name ").append(string2).append("*"))), n3);
                            this.cnc = concept3;
                        }
                    }
                }
                this.stm.ss.spec.regain();
            } else {
                if (concept2 == null) {
                    this.stm.ss.spec.con(61).con(concept);
                    if (this.stm.ss.spec.hasConnect(61)) {
                        concept3 = concept;
                        this.stm.ss.spec.con(61);
                        concept4 = this.stm.ss.spec.getFirst(56);
                        if (this.stm.ss.spec.getNext(56) != null) {
                            this.warnErr("Ambiguous specific type", this.begin + 1);
                            this.type = Session.types[concept4.toNumber()];
                        }
                    }
                } else {
                    this.stm.ss.spec.con(57).con(concept2);
                    if (this.stm.ss.spec.hasConnect(57)) {
                        concept4 = concept2;
                        this.stm.ss.spec.con(57);
                        concept3 = this.stm.ss.spec.get(concept);
                    }
                }
                this.stm.ss.spec.regain();
            }
            if (concept3 == null) {
                if (bl) {
                    this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Unrecognized specific name ").append(string2).append("*"))), n3);
                    this.index = -10;
                    return;
                }
            } else {
                if (bl) {
                    this.cnc = concept3;
                }
                concept = concept3;
                string2 = concept3.toString();
            }
            if (concept4 == null) {
                if (concept2 == null) {
                    this.index = -3;
                    concept2 = new Concept(-this.index);
                    this.type = "mul";
                }
            } else if (concept2 == null) {
                this.index = -concept4.toNumber();
                concept2 = concept4;
            }
            switch (this.index) {
                case -5: {
                    this.index = 4;
                    this.cnc = new Concept("$".concat(String.valueOf(String.valueOf(string2))));
                    return;
                }
                case -4: {
                    if (n != 128) {
                        this.warnErr0("Unexpected procedure");
                        this.index = -10;
                    } else if (concept3 == null) {
                        this.warnErr("Unrecognized procedure name", n3);
                        this.index = -10;
                    }
                    return;
                }
                case -3: {
                    break;
                }
                case -2: {
                    if ((n & 8) == 0) {
                        this.warnErr0("Unexpected file specification");
                        this.index = -10;
                        return;
                    }
                    if ((string2 = string2.trim()).equals("")) {
                        this.warnErr0("Indefined file name");
                        this.index = -10;
                        return;
                    }
                    this.file = new File(string2);
                    break;
                }
                case -1: {
                    if ((n & 0xFFFFFF7B) != 0) {
                        this.warnErr0("Unexpected base specification");
                        this.index = -10;
                        return;
                    }
                    if ((string2 = string2.trim()).length() != 0 && string2.indexOf(46) < 0) {
                        string2 = String.valueOf(String.valueOf(string2)).concat(".ass");
                    }
                    this.stm.sNewBase = string2;
                    this.stm.ss.spec.con(57).con(concept2);
                    this.stm.ss.spec.con(57).con(concept);
                    if (n == 128) {
                        this.stm.ss.modify = !this.stm.ss.spec.hasConnect(59);
                    } else if ((n & 4) != 0) {
                        this.stm.ss.spec.clearConnect(59);
                        this.stm.ss.modify = true;
                    } else {
                        this.stm.ss.spec.setConnect(59, new Concept());
                        this.stm.ss.modify = false;
                    }
                    this.stm.ss.spec.regain();
                }
            }
            if (concept4 == null || concept3 == null) {
                this.stm.ss.spec.con(61).con(concept);
                this.stm.ss.spec.setConnect(61, concept2);
                this.stm.ss.spec.regain();
                this.stm.ss.spec.con(57).con(concept2);
                this.stm.ss.spec.setConnect(57, concept);
                this.stm.ss.spec.regain();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void construeSpace(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        if ((n & 0x80) != 0) {
            this.stm.modify = true;
        }
        Expression expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.eContext = expression;
            expression2.feature = n;
            switch (expression2.index) {
                case 4: {
                    expression2.construeWord();
                    break;
                }
                case 2: {
                    expression2.construeNumber();
                    if (expression2.index == -10) {
                        this.list.remove();
                    }
                    return;
                }
                case 3: {
                    expression2.construeString();
                    if (expression2.index == -10) {
                        this.list.remove();
                    }
                    return;
                }
                case 1: {
                    return;
                }
            }
            if (expression2.index == -10) {
                this.list.remove();
            }
            expression2 = (Expression)this.list.getNext();
        }
        expression2 = (Expression)this.list.getFirst();
        this.cnc = expression2.cnc;
        expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            this.cnc = new Concept(this.cnc, 56, expression2.cnc);
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeWord() {
        this.cnc = new Concept(this.text.substring(this.begin, this.end));
    }

    void construeNumber() {
        int n = this.end - this.begin - 1;
        if (n == 0) {
            return;
        }
        long l = Long.parseLong(this.text.substring(this.begin + 1, this.end));
        if (l > (long)Integer.MAX_VALUE) {
            this.warnErr0("Number > PN.MAX_NUMBER(2147483647)");
            this.index = -10;
            return;
        }
        this.cnc = new Concept((int)l);
    }

    void construeString() {
        this.cnc = new Concept(this.text.substring(this.begin, this.end));
    }

    void construeBrace(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        if ((n & 0x80) != 0) {
            this.stm.modify = true;
        }
        n = n & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getLast();
        this.end = expression2.end + 1;
        this.list = expression2.list;
        Expression expression3 = (Expression)this.list.getFirst();
        while (expression3 != null) {
            expression3.construe(expression, n);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression3 = (Expression)this.list.getNext();
        }
    }

    void construeBracket(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        n = n & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getLast();
        this.end = expression2.end + 1;
        this.list = expression2.list;
        Expression expression3 = (Expression)this.list.getFirst();
        while (expression3 != null) {
            expression3.construe(null, n);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression3 = (Expression)this.list.getNext();
        }
    }

    void construeParenthesis(Expression expression, int n) throws IOException {
        Expression expression2 = (Expression)this.list.getFirst();
        if (expression2.index != -10) {
            this.construeProcedure(expression, n);
            return;
        }
        this.eContext = expression;
        this.feature = n;
        n = n & 0x80 | 0x40;
        Expression expression3 = (Expression)this.list.getLast();
        this.end = expression3.end + 1;
        this.list = expression3.list;
        int n2 = 0;
        expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(null, n);
            if (expression2.index == -10 && ++n2 > 1) {
                if (expression2.copula == null) {
                    expression2.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeProcedure(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.feature = n;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construeSpecific(expression, n);
        if (expression2.index == -10) {
            this.index = -10;
            return;
        }
        if (expression2.index != -4) {
            expression2.warnErr("Unrecognized procedure name", expression2.begin + 1);
            this.index = -10;
            return;
        }
        if (this.stm.root != null) {
            this.warnErr0("Unexpected procedure");
            this.index = -10;
            return;
        }
        this.begin = expression2.begin;
        this.index = -4;
        this.cnc = expression2.cnc;
        Expression expression3 = (Expression)this.list.getNext();
        Expression expression4 = (Expression)expression3.list.getLast();
        this.end = expression4.index == -10 ? expression4.begin + 1 : expression3.end + 1;
        this.list = expression3.list;
        this.stm.proc = new Procedure(this);
        this.stm.proc.construe();
    }

    void construeParenthesisTerm(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n);
        expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            expression2.construe(expression, n);
            if (expression2.index == -10) {
                this.list.remove();
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeRange(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        n = n & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getLast();
        expression2.construe(expression, n);
        Expression expression3 = (Expression)this.list.getFirst();
        expression3.construe(expression, n);
        Expression expression4 = expression3;
        Expression expression5 = (Expression)this.list.getNext();
        while (expression5 != expression2) {
            expression4.warnErr1("Surplus '^' range");
            expression4 = expression5;
            this.list.remove();
            expression5 = (Expression)this.list.getNext();
        }
        if (expression3.index == -10 && expression2.index == -10) {
            this.warnErr0("Unexpected '^' range");
            this.list.remove();
        }
    }

    /*
     * Unable to fully structure code
     */
    void construeColon(Expression var1_1, int var2_2) {
        var3_3 = null;
        this.eContext = var1_1;
        this.feature = var2_2;
        var2_2 = var2_2 & 128 | 64;
        var4_4 = (Expression)this.list.getFirst();
        while (var4_4 != null) {
            var4_4.construe(var1_1, var2_2);
            if (var4_4.index != -10) ** GOTO lbl-1000
            if (!this.list.hasNext()) {
                return;
            }
            if (var3_3 != null) {
                if (var4_4.copula == null) {
                    var4_4.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            } else lbl-1000:
            // 2 sources

            {
                if (var3_3 == null) {
                    var3_3 = var4_4;
                }
                var1_1 = var4_4;
            }
            var4_4 = (Expression)this.list.getNext();
        }
    }

    void construeDivide(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        n &= 0xFFFFFF7F;
        n = n & 0x80 | 0x40;
        int n2 = 0;
        boolean bl = false;
        Expression expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(expression, n);
            if (expression2.index == -10 && expression2.copula != null) {
                this.list.remove();
                break;
            }
            if (expression2.index == -10 && bl) {
                expression2.warnErr0("Unexpected indefinitude");
                this.list.remove();
                break;
            }
            if (++n2 == 3) break;
            bl = expression2.index == -10;
            expression = expression2;
            expression2 = (Expression)this.list.getNext();
        }
        if (n2 == 3 && this.list.hasNext()) {
            expression2.warnErr1("Redundant '/' divider");
        }
        expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            this.list.remove();
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeLeftSlash(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        n = n & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getLast();
        expression2.construe(expression, n);
        if (expression2.index == -10) {
            this.index = -10;
            if (expression2.copula == null) {
                expression2.warnErr0("Unexpected indefinitude");
            }
        }
    }

    void construeRightSlash(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        n = n & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n);
        if (expression2.index == -10) {
            this.index = -10;
        }
        Expression expression3 = (Expression)this.list.getNext();
        expression3.construe(null, n);
        Expression expression4 = (Expression)this.list.getNext();
        while (expression4 != null) {
            expression4.construe(null, n);
            if (expression4.index == -10 && expression4.copula != null) {
                this.list.remove();
            }
            expression4 = (Expression)this.list.getNext();
        }
    }

    void construeExtraction(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        Expression expression2 = (Expression)this.list.getLast();
        if (this.copula.look == '~') {
            expression2.construe(expression, n &= 0xFFFFFF7F);
            if (expression2.index != -1 && n != 128) {
                this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Unexpected '").append(this.copula.look).append("' symbol"))), this.copula.position);
                this.index = -10;
            }
            return;
        }
        if ((n & 4) != 0) {
            this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Unexpected '").append(this.copula.look).append("' symbol"))), this.copula.position);
            this.list.getFirst();
            this.list.remove();
            expression2.construe(expression, n);
            return;
        }
        expression2.construe(expression, n &= 0);
        if (expression2.index == -10) {
            if (expression2.copula == null) {
                expression2.warnErr0("Unexpected indefinitude");
            }
            this.index = -10;
            return;
        }
        if (expression2.index == -1) {
            this.stm.ss.modify = false;
            ++this.stm.scr.modifyCount;
        }
    }

    void construeDeclaration(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        if ((n &= 0x80) != 128) {
            n |= 0x40;
        }
        n = this.copula.look == '~' ? (n &= 0xFFFFFF7F) : (n |= 0x80);
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n |= 4);
        if (expression2.index == -10) {
            if (expression2.copula == null) {
                expression2.warnErr0("Unexpected indefinitude");
            }
            this.index = -10;
            return;
        }
        if (expression2.index == -1) {
            this.stm.ss.modify = true;
            ++this.stm.scr.modifyCount;
        } else if ((n & 0x80) != 0) {
            this.stm.modify = true;
        }
    }

    void construeAssignement(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        n = this.index == 18 ? n & 0x80 & 0xFFFFFF7F : n & 0x80 | 0x80;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n |= 0x40);
        Expression expression3 = (Expression)this.list.getNext();
        while (expression3 != null) {
            expression3.construe(expression, n);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression3 = (Expression)this.list.getNext();
        }
        if (expression2.index == -10) {
            this.index = -10;
        }
    }

    void construeEquality(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        n = n & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n);
        Expression expression3 = (Expression)this.list.getNext();
        while (expression3 != null) {
            expression3.construe(expression, n);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression3 = (Expression)this.list.getNext();
        }
    }

    void construeComma(Expression expression, int n) {
        this.eContext = expression;
        this.feature = n;
        Expression expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(expression, n);
            if (expression2.index == -10) {
                if (expression2.copula == null) {
                    expression2.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void executeStatement() {
        this.executeStatement(null);
    }

    void executeStatement(Association association) {
        try {
            if (this.index < 21) {
                this.executeStatement1(association);
            } else {
                Long1 long1 = Memory.init();
                Expression expression = (Expression)this.list.getFirst();
                while (expression != null) {
                    if (expression.executeStatement1(association)) {
                        if (this.ass == null) {
                            this.ass = expression.ass;
                        } else {
                            this.ass.set(expression.ass);
                        }
                        expression.ass = null;
                    }
                    this.controlMemory(long1, this.list);
                    expression = (Expression)this.list.getNext();
                }
            }
        }
        catch (ZException zException) {
            throw zException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.freeInnerExpression();
            new Error(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    boolean executeStatement1(Association association) {
        Procedure procedure;
        if (this.needLogin()) {
            procedure = new Procedure("login", this);
            procedure.execute();
        }
        if (this.index == 17 && this.feature == 128) {
            Expression expression = (Expression)this.list.getLast();
            if (expression.index != -1) {
                this.feature = 8;
                procedure = new Procedure("printEquality", this);
                procedure.equality = true;
                procedure.execute();
                return false;
            }
        }
        return this.execute(association);
    }

    boolean needLogin() {
        if (this.stm.ss.access == 1) {
            return false;
        }
        if (this.index == -4 && this.stm.proc.index == 9) {
            return false;
        }
        Expression expression = this.index == 17 ? (Expression)this.list.getLast() : (this.index == 20 ? (Expression)this.list.getFirst() : this);
        return expression.index != -1;
    }

    boolean execute() {
        return this.execute(null);
    }

    boolean execute(Association association) {
        try {
            boolean bl = this.execute1(association);
            return bl;
        }
        catch (ZException zException) {
            throw zException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.freeInnerExpression();
            new Failure(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    boolean execute1(Association association) throws IOException {
        switch (this.index) {
            case -10: {
                return this.executeNone(association);
            }
            case -1: {
                this.stm.ss.openModify(this.stm.sNewBase);
                return false;
            }
            case -4: {
                return this.stm.proc.execute();
            }
            case -3: {
                return this.executeMultitude(association);
            }
            case 1: {
                return this.executeNames(association);
            }
            case 2: 
            case 3: {
                return this.executeDesignation(association);
            }
            case 4: {
                return this.executeWord(association);
            }
            case 5: {
                return this.executeSpace(association);
            }
            case 6: {
                return this.executeBrace(association);
            }
            case 7: {
                return this.executeBracket(association);
            }
            case 11: {
                return this.executeParenthesisTerm(association);
            }
            case 12: {
                return this.executeRange(association);
            }
            case 13: {
                return this.executeColon(association);
            }
            case 14: {
                return this.executeDivide(association);
            }
            case 15: {
                return this.executeLeftSlash(association);
            }
            case 16: {
                return this.executeRightSlash(association);
            }
            case 17: {
                return this.executeExtraction(association);
            }
            case 20: {
                return this.executeDeclaration(association);
            }
            case 18: {
                if ((this.feature & 0x80) == 0) {
                    return this.executeInEquality(association);
                }
                return this.executeSubtruction(association);
            }
            case 19: {
                if ((this.feature & 0x80) == 0) {
                    return this.executeEquality(association);
                }
                return this.executeAssignement(association);
            }
            case 21: {
                return this.executeComma(association);
            }
        }
        return false;
    }

    boolean executeNone(Association association) throws IOException {
        if ((this.feature & 0x80) == 0) {
            return this.requestNone(association);
        }
        return this.describeNone(association);
    }

    boolean requestNone(Association association) throws IOException {
        this.ass = association;
        return this.yields1();
    }

    boolean describeNone(Association association) throws IOException {
        this.ass = this.stm.ss.db.insertDesignation(association, null, false);
        return this.yields1();
    }

    boolean executeMultitude(Association association) throws IOException {
        this.ass = this.mul(this.cnc.toString());
        if (!this.yields()) {
            return false;
        }
        if (association == null) {
            this.ass = this.ass.get();
            return true;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectClass(association, this.ass) : this.stm.ss.db.insertClass(association, this.ass);
        return this.yields1();
    }

    Association mul(String string) {
        Association association = (Association)this.stm.ss.mh.h.get(string);
        if (association == null) {
            association = new Association();
            this.stm.ss.mh.h.put(string, association);
        }
        return association;
    }

    boolean executeNames(Association association) throws IOException {
        this.ass = this.stm.ss.db.selectNames(association);
        return this.yields1();
    }

    boolean executeDesignation(Association association) throws IOException {
        if (association == null && this.cnc != null) {
            this.ass = new Association();
            this.ass.set(this.cnc);
            return true;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectDesignation(association, this.cnc, false) : this.stm.ss.db.insertDesignation(association, this.cnc, false);
        return this.yields1();
    }

    boolean executeWord(Association association) throws IOException {
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectName(association, this.cnc) : this.stm.ss.db.insertName(association, this.cnc);
        return this.yields1();
    }

    boolean executeSpace(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        this.ass = expression.index == 3 || expression.index == 2 ? ((this.feature & 0x80) == 0 ? this.stm.ss.db.selectDesignation(association, expression.cnc, true) : this.stm.ss.db.insertDesignation(association, expression.cnc, true)) : ((this.feature & 0x80) == 0 ? this.stm.ss.db.selectName(association, this.list) : this.stm.ss.db.insertName(association, this.list));
        return this.yields1();
    }

    boolean executeBrace(Association association) throws IOException {
        Long1 long1 = Memory.init();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            if (expression.execute(association)) {
                if (this.ass == null) {
                    this.ass = expression.ass;
                } else {
                    if (this.ass.getSense1() != expression.ass.getSense1()) {
                        this.deriveInstance();
                        expression.deriveInstance();
                    }
                    if (this.ass.getResolution() <= expression.ass.getResolution()) {
                        this.ass.set(expression.ass);
                    } else {
                        expression.ass.set(this.ass);
                        this.ass = expression.ass;
                    }
                }
                expression.ass = null;
                this.controlMemory(long1, association);
            }
            expression = (Expression)this.list.getNext();
        }
        return this.ass != null;
    }

    boolean deriveClass() throws IOException {
        if (this.ass.getSense0() == 64) {
            return true;
        }
        PList pList = new PList();
        pList.add(57, null);
        int n = this.ass.getResolution();
        this.ass = this.stm.ss.db.base.getBy(this.ass, pList);
        this.ass.setResolution(n);
        return this.yields1();
    }

    boolean deriveInstance() throws IOException {
        return this.deriveInstance(false);
    }

    boolean deriveInstance(boolean bl) throws IOException {
        if (this.ass.getSense1() != 57) {
            return this.ass.has();
        }
        int n = this.ass.getResolution();
        this.ass = this.stm.ss.db.base.get(this.ass);
        this.ass.setResolution(n);
        if (bl) {
            return this.yields1();
        }
        if (this.ass.has()) {
            return true;
        }
        if (this.feature != 128) {
            this.warnFail(this.eContext, "");
        }
        return false;
    }

    boolean executeBracket(Association association) throws IOException {
        Long1 long1 = Memory.init();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            if (expression.execute(null)) {
                if (this.ass == null) {
                    this.ass = expression.ass;
                } else {
                    if (this.ass.getSense1() != expression.ass.getSense1()) {
                        this.deriveInstance();
                        expression.deriveInstance();
                    }
                    if (this.ass.getResolution() <= expression.ass.getResolution()) {
                        this.ass.set(expression.ass);
                    } else {
                        expression.ass.set(this.ass);
                        this.ass = expression.ass;
                    }
                }
                expression.ass = null;
                this.controlMemory(long1, association);
            }
            expression = (Expression)this.list.getNext();
        }
        if (this.ass == null) {
            return false;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectClass(association, this.ass) : this.stm.ss.db.insertClass(association, this.ass);
        return this.yields1();
    }

    boolean executeParenthesisTerm(Association association) throws IOException {
        if ((this.feature & 0x80) == 0) {
            return this.requestParenthesisTerm(association);
        }
        return this.describeParenthesisTerm(association);
    }

    boolean requestParenthesisTerm(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (expression.index == -10 && (association == null || association == PN.aNull)) {
            this.ass = new Association();
        } else {
            if (!expression.execute(association)) {
                return false;
            }
            this.ass = expression.ass;
            expression.ass = null;
        }
        PList pList = new PList();
        PList pList2 = new PList();
        Long1 long1 = Memory.init();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            PList pList3 = expression2.list;
            expression2 = (Expression)pList3.getFirst();
            while (expression2 != null) {
                if (expression2.index == -10) {
                    pList.add(59, null);
                    break;
                }
                if (!expression2.execute(null)) {
                    this.ass = null;
                    return false;
                }
                pList.add(59, (Object)expression2.ass);
                expression2.ass = null;
                pList2.add(expression2);
                Memory.control(long1, this.ass, pList);
                expression2 = (Expression)pList3.getNext();
            }
            expression2 = (Expression)this.list.getNext();
        }
        pList = this.stm.ss.db.selectSchema(this.ass, pList, pList2);
        if (!pList2.isEmpty() || pList == null) {
            expression.warnFail("", pList2, "Non-existent schema");
            this.ass = null;
            return false;
        }
        this.ass = this.stm.ss.db.selectRelation(this.ass, pList);
        return this.yields1();
    }

    boolean describeParenthesisTerm(Association association) throws IOException {
        PList pList;
        Expression expression;
        Expression expression2 = (Expression)this.list.getFirst();
        if (expression2.index == -10) {
            expression = (Expression)this.list.getNext();
            if (!this.executeKeyParenthesisTerm(association, expression2, expression)) {
                return false;
            }
            if (!this.list.hasNext()) {
                return true;
            }
        } else {
            if (!expression2.execute(association)) {
                return false;
            }
            this.ass = expression2.ass;
            expression2.ass = null;
        }
        PList pList2 = new PList();
        PList pList3 = new PList();
        Long1 long1 = Memory.init();
        expression = (Expression)this.list.getNext();
        while (expression != null) {
            pList = expression.list;
            expression = (Expression)pList.getFirst();
            while (expression != null) {
                if (expression.index == -10) {
                    pList2.add(59, null);
                    break;
                }
                if (expression.execute(null)) {
                    pList2.add(59, (Object)expression.ass);
                    expression.ass = null;
                    pList3.add(expression);
                    Memory.control(long1, this.ass, pList2);
                }
                expression = (Expression)pList.getNext();
            }
            expression = (Expression)this.list.getNext();
        }
        pList = this.stm.ss.db.insertSchema(this.ass, pList2, pList3);
        if (!pList3.isEmpty()) {
            expression2.warnFail("", pList3, "Non-describable schema");
        }
        if (pList != null) {
            this.stm.ss.db.insertContent0(this.ass, pList);
            this.stm.ss.db.insertRelation(this.ass, pList);
        }
        return this.yields1();
    }

    boolean executeKeyParenthesisTerm(Association association, Expression expression, Expression expression2) throws IOException {
        PList pList = new PList();
        pList.add(new Expression(this.stm, expression.begin, 2));
        PList pList2 = expression2.list;
        Expression expression3 = (Expression)pList2.getFirst();
        if (expression3.index == -10) {
            this.ass = this.stm.ss.db.insertDesignation(association, pList);
            return true;
        }
        PList pList3 = new PList();
        PList pList4 = new PList();
        Long1 long1 = Memory.init();
        while (expression3 != null) {
            if (!expression3.execute(null)) {
                return false;
            }
            pList3.add(59, (Object)expression3.ass);
            expression3.ass = null;
            pList4.add(expression3);
            Memory.control(long1, this.stm.ss.db.base, pList3);
            expression3 = (Expression)pList2.getNext();
        }
        if (association == null || association == PN.aNull) {
            this.stm.ss.db.base.see(36);
            this.ass = this.stm.ss.db.base.getBy(56, pList3);
            this.stm.ss.db.base.see();
        } else {
            this.ass = this.stm.ss.db.base.getBy(association, 56, pList3);
        }
        if (this.ass.has()) {
            return true;
        }
        this.ass = this.stm.ss.db.insertDesignation(association, pList);
        PList pList5 = this.stm.ss.db.insertSchema(this.ass, pList3, pList4);
        if (!pList4.isEmpty()) {
            this.warnFail("", pList4, "Non-describable schema");
            this.stm.ss.db.base.clear(this.ass);
            this.ass = null;
            return false;
        }
        this.stm.ss.db.insertContent0(this.ass, pList5);
        this.stm.ss.db.insertRelation(this.ass, pList5);
        return this.yields1();
    }

    boolean executeRange(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        if (expression.index == -10 && expression2.index == -10) {
            if (association == null || association == PN.aNull) {
                this.ass = this.stm.ss.db.base.get();
            } else {
                this.ass = association.get();
                this.ass.setSense(57);
            }
            return this.yields1();
        }
        if (!(expression.index == -10 || expression.execute(association) && expression.deriveInstance())) {
            return false;
        }
        if (!(expression2.index == -10 || expression2.execute(association) && expression2.deriveInstance())) {
            return false;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectInterval(association, expression.ass, expression2.ass) : this.stm.ss.db.selectInterval(association, expression.ass, expression2.ass);
        expression.ass = null;
        expression2.ass = null;
        return this.yields1();
    }

    boolean executeColon(Association association) throws IOException {
        Expression expression = null;
        int n = 0;
        Long1 long1 = Memory.init();
        if (association != null) {
            n = association.getSense();
        }
        this.ass = association;
        Expression expression2 = (Expression)this.list.getFirst();
        if (expression2.index == -10) {
            if (this.ass == null) {
                this.ass = PN.aNull;
            }
            expression = expression2;
            expression2 = (Expression)this.list.getNext();
        }
        boolean bl = false;
        while (expression2 != null) {
            if (this.ass != null && this.ass != PN.aNull) {
                if (expression != null && expression.unaided()) {
                    this.ass.setSense(121);
                    bl = true;
                } else {
                    this.ass.setSense(57);
                }
            }
            if (expression2.index == -10) {
                if (!this.list.hasNext()) break;
            } else {
                expression = expression2;
                if (expression2.index == 1 && (this.ass == null || this.ass == PN.aNull)) {
                    expression2 = (Expression)this.list.getNext();
                    if (this.ass == null) {
                        if (expression2.index == -10) {
                            this.ass = this.stm.ss.db.selectNames(null, PN.aNull);
                            break;
                        }
                    } else if (this.ass == PN.aNull) {
                        if (expression2 == null) {
                            this.ass = this.stm.ss.db.selectNames(PN.aNull, null);
                            break;
                        }
                        if (expression2.index == -10) {
                            this.ass = this.stm.ss.db.selectNames(PN.aNull, PN.aNull);
                            break;
                        }
                    }
                    expression2 = (Expression)this.list.getBack();
                }
                if (!expression2.execute(this.ass)) {
                    if (bl) {
                        this.ass.setSense(64);
                        break;
                    }
                    this.ass = null;
                    break;
                }
                this.ass = expression2.ass;
                expression2.ass = null;
                this.controlMemory(long1);
            }
            expression2 = (Expression)this.list.getNext();
        }
        if (association != null) {
            association.setSense(n);
        }
        if (this.ass == null) {
            return false;
        }
        return this.yields1();
    }

    boolean unaided() {
        if (this.index != 11) {
            return false;
        }
        this.list.getFirst();
        Expression expression = (Expression)this.list.getNext();
        while (expression != null) {
            Expression expression2 = (Expression)expression.list.getFirst();
            if (expression2.index == -10) {
                return true;
            }
            expression = (Expression)this.list.getNext();
        }
        return false;
    }

    boolean executeDivide(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        Expression expression3 = (Expression)this.list.getNext();
        DataBase dataBase = this.stm.ss.db;
        Association association2 = new Association();
        boolean bl = false;
        if (expression3 == null) {
            if (expression2.index == -10) {
                bl = expression.execute(association);
                if (bl) {
                    bl = expression.ass.getSense0() == 64;
                }
                Association association3 = expression.ass;
                expression.ass = null;
                if (!bl) {
                    return false;
                }
                this.ass = dataBase.selectInstance(association3);
            } else if (expression.index == -10) {
                dataBase.def = association2;
                bl = this.executeColon(association);
                dataBase.def = null;
                if (!bl) {
                    return false;
                }
                if (association2.has()) {
                    this.ass = this.ass.get(association2, 57, 64, 64, -1, 0);
                }
            } else {
                if (!this.executeColon(association)) {
                    return false;
                }
                bl = expression.execute(association);
                if (bl) {
                    bl = expression.ass.getSense0() == 64;
                }
                Association association4 = expression.ass;
                expression.ass = null;
                this.ass = bl ? this.ass.getValue(association4) : null;
            }
            return this.yields1();
        }
        if (expression.index == -10 && expression3.index == -10) {
            this.list.remove();
            dataBase.def = association2;
            bl = this.executeColon(association);
            if (bl) {
                bl = this.deriveClass();
            }
            dataBase.def = null;
            if (!bl) {
                this.list.add(this.copula.look, (Object)expression3);
                return false;
            }
            if (association2.has()) {
                this.ass = this.ass.get(association2, 57, 64, 64, -1, 0);
            }
            if (!this.ass.has()) {
                this.yields1();
                this.list.add(this.copula.look, (Object)expression3);
                return false;
            }
            this.list.add(this.copula.look, (Object)expression3);
            this.ass = dataBase.selectInstance(this.ass);
            return this.yields1();
        }
        bl = expression.execute(association);
        if (bl) {
            bl = expression.deriveClass();
        }
        if (!bl) {
            return false;
        }
        Association association5 = expression.ass;
        association5.setSense(57);
        expression.ass = null;
        dataBase.def = association2;
        bl = expression3.execute(association5);
        if (bl) {
            bl = expression3.deriveInstance();
        }
        dataBase.def = null;
        if (!bl) {
            return false;
        }
        if (association2.has()) {
            this.ass = expression3.ass.get(association2, 57, 64, 64, -1, 0);
        }
        expression3.ass = null;
        if (!this.ass.has()) {
            this.list.getFirst();
            this.list.remove();
            this.yields1();
            this.list.getFirst();
            this.list.insert(expression);
            return false;
        }
        this.ass = this.ass.getValue(association5);
        return this.yields1();
    }

    boolean executeLeftSlash(Association association) throws IOException {
        char c = '\u0000';
        Expression expression = (Expression)this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            c = (char)this.list.getType();
            if (!this.list.hasNext()) break;
            expression2 = (Expression)this.list.getNext();
        }
        if (!expression2.execute(association)) {
            return false;
        }
        this.ass = expression2.ass;
        expression2.ass = null;
        if (expression.index == -10) {
            if (c == '\\') {
                this.ass.setResolution(-1);
            } else if (c == '|') {
                this.ass.setResolution(1);
            }
        } else if (c == '\\') {
            this.ass = this.ass.getName();
        } else if (c == '|') {
            if (!this.deriveInstance(true)) {
                return false;
            }
            this.ass = this.ass.getMean();
        }
        return this.yields1();
    }

    boolean executeRightSlash(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (!expression.execute(association) || !expression.deriveInstance()) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            char c = (char)this.list.getType();
            if (c == '|') {
                this.ass = this.ass.getValues();
            } else if (c == '\\') {
                this.ass = this.ass.getNames();
            }
            if (!this.ass.has()) break;
            if (expression2.index != -10) {
                if (expression2.index == 1) {
                    this.ass = this.ass.get(56);
                } else {
                    if (c == '|') {
                        if (!expression2.execute(PN.aNull)) {
                            this.ass = null;
                            return false;
                        }
                        expression2.ass = expression2.ass.getValues();
                    } else if (c == '\\' && !expression2.execute(association)) {
                        this.ass = null;
                        break;
                    }
                    this.ass = this.ass.get(expression2.ass);
                    expression2.ass = null;
                }
            }
            expression2 = (Expression)this.list.getNext();
        }
        return this.yields1();
    }

    boolean executeExtraction(Association association) throws IOException {
        Expression expression = (Expression)this.list.getLast();
        if (expression.index == -1) {
            if (this.copula.look == '~') {
                this.stm.ss.closeBase(this.stm.sNewBase);
            } else {
                this.stm.ss.openUse(this.stm.sNewBase);
            }
            return false;
        }
        if (!expression.execute(association)) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        return true;
    }

    boolean executeDeclaration(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (expression.index == -1) {
            if (this.copula.look == '~') {
                this.stm.ss.openNew(this.stm.sNewBase);
            } else {
                this.stm.ss.openModify(this.stm.sNewBase);
            }
            return false;
        }
        if (association == null && expression.index == -3) {
            if (this.copula.look == '~') {
                expression.ass = this.mul(expression.cnc.toString());
                expression.ass.clear();
            }
            return this.yields();
        }
        if (!expression.execute(association)) {
            return false;
        }
        if (this.copula.look == '~') {
            if (expression.deriveClass()) {
                this.stm.ss.db.deleteClass(expression.ass);
            }
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        return true;
    }

    boolean executeSubtruction(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (association == null && expression.index == -3) {
            expression.ass = this.mul(expression.cnc.toString());
        } else if (!expression.execute(association)) {
            return false;
        }
        Long1 long1 = Memory.init();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            Expression expression3 = (Expression)expression2.list.getFirst();
            if (expression3 != null && expression3.index == -10 && expression2.index == 11) {
                expression.subtructionOfRelation(expression2);
            } else if (expression3 != null && expression3.index == -10 && expression2.index == 13) {
                expression.subtructionOfClass(expression2);
            } else if (association == null && expression.index == -3) {
                expression.subtructionFromMultitude(expression2);
            } else {
                expression.subtructionFromConception(association, expression2);
            }
            expression2.ass = null;
            if (!expression.ass.has()) break;
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        this.ass = association == null && expression.index == -3 ? expression.ass.get() : expression.ass;
        expression.ass = null;
        if (this.feature != 128) {
            return this.yields1();
        }
        return this.ass.has();
    }

    boolean executeAssignement(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (association == null && expression.index == -3) {
            expression.ass = this.mul(expression.cnc.toString());
        } else if (!expression.execute(association)) {
            return false;
        }
        Long1 long1 = Memory.init();
        this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            Expression expression3 = (Expression)expression2.list.getFirst();
            if (expression3 != null && expression3.index == -10 && expression2.index == 11) {
                expression.assignementOfRelation(expression2);
            } else if (expression3 != null && expression3.index == -10 && expression2.index == 13) {
                expression.assignementOfClass(expression2);
            } else if (association == null && expression.index == -3) {
                expression.assignementToMultitude(expression2);
            } else {
                expression.assignementToConception(association, expression2);
            }
            expression2.ass = null;
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        this.ass = association == null && expression.index == -3 ? expression.ass.get() : expression.ass;
        expression.ass = null;
        if (this.feature != 128) {
            return this.yields1();
        }
        return this.ass.has();
    }

    void subtructionOfRelation(Expression expression) throws IOException {
        PList pList = expression.list;
        pList.getFirst();
        PList pList2 = new PList();
        PList pList3 = new PList();
        Long1 long1 = Memory.init();
        expression = (Expression)pList.getNext();
        while (expression != null) {
            PList pList4 = expression.list;
            expression = (Expression)pList4.getFirst();
            while (expression != null) {
                if (expression.index == -10) {
                    this.stm.ss.db.deleteRelation(this.ass);
                    return;
                }
                if (expression.execute(null)) {
                    pList2.add(59, (Object)expression.ass);
                    expression.ass = null;
                    pList3.add(expression);
                    Memory.control(long1, this.ass, pList2);
                }
                expression = (Expression)pList4.getNext();
            }
            expression = (Expression)pList.getNext();
        }
        pList2 = this.stm.ss.db.selectPropertySchema(this.ass, pList2, pList3);
        if (!pList3.isEmpty()) {
            this.warnFail(" ~ ", pList3, "Non-existent schema");
        }
        if (pList2 != null) {
            this.stm.ss.db.deleteRelation(this.ass, pList2);
        }
    }

    void assignementOfRelation(Expression expression) throws IOException {
        PList pList = expression.list;
        pList.getFirst();
        PList pList2 = new PList();
        PList pList3 = new PList();
        Long1 long1 = Memory.init();
        expression = (Expression)pList.getNext();
        while (expression != null) {
            PList pList4 = expression.list;
            expression = (Expression)pList4.getFirst();
            while (expression != null) {
                if (expression.index == -10) {
                    pList2.add(59, null);
                    pList3.add(expression);
                    break;
                }
                if (expression.execute(null)) {
                    pList2.add(59, (Object)expression.ass);
                    expression.ass = null;
                    pList3.add(expression);
                    Memory.control(long1, this.ass, pList2);
                }
                expression = (Expression)pList4.getNext();
            }
            expression = (Expression)pList.getNext();
        }
        pList2 = this.stm.ss.db.insertSchema(this.ass, pList2, pList3);
        if (!pList3.isEmpty()) {
            this.warnFail(" = ", pList3, "Non-describable schema");
        }
        if (pList2 != null) {
            this.stm.ss.db.insertRelation(this.ass, pList2);
        }
    }

    void subtructionOfClass(Expression expression) throws IOException {
        Long1 long1 = Memory.init();
        Expression expression2 = (Expression)expression.list.getFirst();
        expression.list.remove();
        if (expression.execute(null) && expression.deriveInstance(true)) {
            int n = this.ass.getSense();
            this.ass.setSense(57);
            this.stm.ss.db.deleteClass(this.ass, expression.ass);
            this.ass.setSense(n);
            expression.ass = null;
        }
        expression.list.getFirst();
        expression.list.insert(expression2);
    }

    void assignementOfClass(Expression expression) throws IOException {
        Long1 long1 = Memory.init();
        Expression expression2 = (Expression)expression.list.getFirst();
        expression.list.remove();
        if (expression.execute(null) && expression.deriveInstance(true)) {
            int n = this.ass.getSense();
            this.ass.setSense(57);
            this.stm.ss.db.insertClass(this.ass, expression.ass);
            this.ass.setSense(n);
            expression.ass = null;
        }
        expression.list.getFirst();
        expression.list.insert(expression2);
    }

    void subtructionFromMultitude(Expression expression) throws IOException {
        if (expression.execute(null) && expression.deriveInstance(true)) {
            this.ass.clear(expression.ass);
        }
    }

    void assignementToMultitude(Expression expression) throws IOException {
        if (expression.execute(null) && expression.deriveInstance(true)) {
            this.ass.set(expression.ass);
        }
    }

    void subtructionFromConception(Association association, Expression expression) throws IOException {
        if (!expression.execute(association)) {
            return;
        }
        PList pList = this.stm.ss.db.selectSchema(this.ass, expression.ass);
        if (pList == null) {
            this.warnFail('~', expression, "Unknown schema");
        } else {
            this.stm.ss.db.deleteIdentity(this.ass, expression.ass);
        }
    }

    void assignementToConception(Association association, Expression expression) throws IOException {
        if (!expression.execute(association)) {
            return;
        }
        PList pList = this.stm.ss.db.insertSchema(this.ass, expression.ass);
        if (pList == null) {
            this.warnFail('=', expression, "Conflicting schema");
        } else if (!pList.isEmpty()) {
            this.stm.ss.db.insertContentByIdentity(this.ass, expression.ass);
            this.stm.ss.db.insertIdentity(this.ass, expression.ass);
        }
    }

    boolean executeInEquality(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (!expression.execute(association) || !expression.deriveInstance(true)) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        Long1 long1 = Memory.init();
        expression = (Expression)this.list.getNext();
        while (expression != null) {
            if (expression.execute(association)) {
                this.ass.clear(expression.ass);
                expression.ass = null;
                if (!this.yields1()) {
                    return false;
                }
                this.controlMemory(long1);
            }
            expression = (Expression)this.list.getNext();
        }
        return true;
    }

    boolean executeEquality(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (!expression.execute(association)) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        Long1 long1 = Memory.init();
        expression = (Expression)this.list.getNext();
        while (expression != null) {
            if (!expression.execute(association)) {
                this.ass = null;
                return false;
            }
            Association association2 = expression.ass.get(this.ass);
            int n = this.ass.getSense();
            int n2 = expression.ass.getSense();
            if (n != 64 && n2 != 64) {
                if (n != 121 && n2 != 121) {
                    association2.setSense(57);
                } else {
                    association2.setSense(121);
                }
            }
            this.ass = association2;
            expression.ass = null;
            if (!this.yields1()) {
                return false;
            }
            this.controlMemory(long1);
            expression = (Expression)this.list.getNext();
        }
        return true;
    }

    boolean executeComma(Association association) throws IOException {
        return this.executeBrace(association);
    }

    void warnErr0(String string) {
        new Error(this.stm, this.begin, string);
    }

    void warnErr1(String string) {
        new Error(this.stm, this.end, string);
    }

    void warnErr(String string, int n) {
        new Error(this.stm, n, string);
    }

    void warnFail0(String string) {
        new Failure(this.stm, this.begin, string);
    }

    void warnFail1(String string) {
        new Failure(this.stm, this.end, string);
    }

    void warnFail(String string, int n) {
        new Failure(this.stm, n, string);
    }

    void warnFail(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer);
        if (string.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        new Failure(this.stm, this.begin, stringBuffer.toString());
    }

    void warnFail(Expression expression, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.contextToStringBuffer(stringBuffer);
        this.toStringBuffer(stringBuffer);
        if (string.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        new Failure(this.stm, this.begin, stringBuffer.toString());
    }

    void warnFail(char c, Expression expression, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.contextToStringBuffer(stringBuffer);
        this.toStringBuffer(stringBuffer);
        stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer(" ").append(c).append(" "))));
        expression.toStringBuffer(stringBuffer);
        if (string.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        new Failure(this.stm, this.begin, stringBuffer.toString());
    }

    void warnFail(String string, PList pList, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.contextToStringBuffer(stringBuffer);
        this.toStringBuffer(stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("(");
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            expression.toStringBuffer(stringBuffer, false);
            if (pList.hasNext()) {
                stringBuffer.append(", ");
            }
            expression = (Expression)pList.getNext();
        }
        stringBuffer.append(") ");
        if (string2.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string2);
        }
        new Failure(this.stm, this.begin, stringBuffer.toString());
    }

    void contextToStringBuffer(StringBuffer stringBuffer) {
        PList pList = new PList();
        while (this.eContext != null) {
            pList.insert(this.eContext);
            this.eContext = this.eContext.eContext;
        }
        boolean bl = true;
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            block6: {
                block5: {
                    block4: {
                        if (!bl) break block4;
                        bl = false;
                        break block5;
                    }
                    if (expression.index == -10) break block6;
                }
                expression.toStringBuffer(stringBuffer);
                stringBuffer.append(":");
            }
            expression = (Expression)pList.getNext();
        }
    }

    boolean yields() throws IOException {
        if (this.ass != null && this.ass.has()) {
            return true;
        }
        this.ass = null;
        if (this.feature != 128) {
            this.warnFail("");
        }
        return false;
    }

    boolean yields1() throws IOException {
        if (this.ass != null && this.ass.has()) {
            return true;
        }
        this.ass = null;
        if (this.feature != 128) {
            this.warnFail(this.eContext, "");
        }
        return false;
    }

    void controlMemory(Long1 long1) throws IOException {
        Memory.control(long1, this.stm.ss.db.base, this.ass);
    }

    void controlMemory(Long1 long1, Association association) throws IOException {
        Memory.control(long1, this.stm.ss.db.base, this.ass, association);
    }

    void controlMemory(Long1 long1, PList pList) throws IOException {
        if (!Memory.filled(long1)) {
            return;
        }
        this.stm.ss.db.store();
        if (this.ass != null) {
            this.ass.store();
        }
        PList pList2 = (PList)pList.clone();
        Expression expression = (Expression)pList2.getFirst();
        while (expression != null) {
            if (expression.ass != null) {
                expression.ass.store();
            }
            expression = (Expression)pList2.getNext();
        }
        Memory.optimize(long1);
    }

    void controlMemory(Long1 long1, Association association, PList pList) throws IOException {
        if (!Memory.filled(long1)) {
            return;
        }
        this.stm.ss.db.store();
        if (this.ass != null) {
            this.ass.store();
        }
        if (association != null) {
            association.store();
        }
        PList pList2 = (PList)pList.clone();
        Expression expression = (Expression)pList2.getFirst();
        while (expression != null) {
            if (expression.ass != null) {
                expression.ass.store();
            }
            expression = (Expression)pList2.getNext();
        }
        Memory.optimize(long1);
    }

    void controlMemory(Long1 long1, Association association, Association association2, PList pList) throws IOException {
        if (!Memory.filled(long1)) {
            return;
        }
        this.stm.ss.db.store();
        if (this.ass != null) {
            this.ass.store();
        }
        if (association != null) {
            association.store();
        }
        if (association2 != null) {
            association2.store();
        }
        PList pList2 = (PList)pList.clone();
        Expression expression = (Expression)pList2.getFirst();
        while (expression != null) {
            if (expression.ass != null) {
                expression.ass.store();
            }
            expression = (Expression)pList2.getNext();
        }
        Memory.optimize(long1);
    }

    void freeInnerExpression() {
        this.ass = null;
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            expression.freeInnerExpression();
            expression = (Expression)this.list.getNext();
        }
    }

    void toStringBuffer(StringBuffer stringBuffer) {
        this.toStringBuffer(stringBuffer, true);
    }

    void toStringBuffer(StringBuffer stringBuffer, boolean bl) {
        String string;
        if (bl) {
            bl = false;
        }
        if (this.index == -10) {
            return;
        }
        if (this.list.isEmpty()) {
            if (this.index <= 0) {
                stringBuffer.append('$');
                if (this.type != null) {
                    stringBuffer.append(this.type).append(" ");
                }
                if (this.text.charAt(this.end - 1) == '\"' || this.text.charAt(this.end - 1) == '\'') {
                    stringBuffer.append('\'');
                    if (this.cnc != null) {
                        stringBuffer.append(this.cnc.toString());
                    }
                    stringBuffer.append('\'');
                } else if (this.cnc != null) {
                    stringBuffer.append(this.cnc.toString());
                }
                return;
            }
            stringBuffer.append(this.text.substring(this.begin, this.end));
            return;
        }
        if (this.index == -4) {
            stringBuffer.append('$');
            if (this.type != null) {
                stringBuffer.append(this.type).append(" ");
            }
            stringBuffer.append(this.cnc.toString());
            stringBuffer.append(this.copula.look);
            string = ", ";
        } else if (this.index == 6 || this.index == 7 || this.index == 8) {
            stringBuffer.append(this.copula.look);
            string = ", ";
        } else if (this.index == 21) {
            string = ", ";
            string = ", ";
        } else {
            string = null;
        }
        Expression expression = (Expression)this.list.getFirst();
        if (expression != null) {
            expression.toStringBuffer(stringBuffer, bl);
        }
        while (this.list.hasNext()) {
            expression = (Expression)this.list.getNext();
            char c = (char)this.list.getType();
            if (string != null) {
                stringBuffer.append(string);
            } else if (this.index == 5) {
                if (expression.index != 1) {
                    stringBuffer.append(" ");
                }
            } else if (this.index == 11) {
                stringBuffer.append(" ");
            } else if ((this.index == 19 || this.index == 18) && (this.feature & 0x80) != 0) {
                stringBuffer.append(" ").append(c).append(" ");
            } else {
                stringBuffer.append(c);
            }
            expression.toStringBuffer(stringBuffer, bl);
        }
        if (this.copula.look == '{') {
            stringBuffer.append("}");
        } else if (this.copula.look == '[') {
            stringBuffer.append(']');
        } else if (this.copula.look == '(') {
            stringBuffer.append(')');
        }
    }
}

