/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Parser.Fielder;
import Sav.Processor.Long1;
import Sav.Processor.Memory;
import Sav.Processor.PList;
import Sav.Z.Error;
import Sav.Z.Failure;
import Sav.Z.Lexis;
import Sav.Z.Session;
import Sav.Z.Statement;
import Sav.Z.ZException;
import java.io.IOException;

public class Script
implements Lexis {
    Session ss;
    PList stmList;
    String text;
    boolean hasError;
    boolean hasFailure;
    boolean isAnalyzed;
    boolean ssModify;
    boolean modify;
    int modifyCount;

    public Script(String string) {
        this.text = string;
        this.stmList = new PList();
    }

    synchronized void analyse(Session session) {
        int n;
        this.ss = session;
        this.ssModify = session.db.isModifiable();
        session.setProcess("Analyzing ...");
        this.stmList = new PList();
        this.hasError = false;
        int n2 = this.text.length();
        int n3 = 0;
        int n4 = n = session.getScriptLine();
        session.setScriptLine(++n4);
        this.modifyCount = 0;
        this.modify = false;
        boolean bl = true;
        try {
            int n5 = Fielder.passSpace(this.text, n3, n2);
            while (true) {
                if (n3 < n5) {
                    if (this.text.charAt(n3) == '\n') {
                        ++n4;
                    }
                    ++n3;
                    continue;
                }
                session.setScriptLine(n4);
                if (n3 != n2) {
                    Statement statement = new Statement(n4, this.text, n3);
                    statement.scr = this;
                    this.stmList.add(statement);
                    statement.analyse(session);
                    this.hasError |= statement.hasErrors();
                    if (statement.modify && this.modifyCount == 0) {
                        this.modify = true;
                    }
                    n5 = statement.end();
                    n5 = Fielder.passSpace(this.text, n5, n2);
                    continue;
                }
                break;
            }
        }
        catch (ZException zException) {
            this.hasError = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.hasError = true;
            new Error(session, exception, n4, n3);
        }
        session.setScriptLine(n);
        session.clearProcess();
        this.isAnalyzed = true;
    }

    boolean isAnalyzed(Session session) {
        return this.isAnalyzed && this.ss == session && (!this.modify || this.ssModify == session.db.isModifiable());
    }

    synchronized void execute(Session session) {
        int n;
        this.hasFailure = false;
        Statement statement = null;
        Statement statement2 = null;
        if (!this.isAnalyzed(session)) {
            this.analyse(session);
        }
        if (!this.hasStatements()) {
            return;
        }
        if (this.hasErrors()) {
            return;
        }
        int n2 = n = session.getScriptLine();
        session.setScriptLine(++n2);
        Object var6_6 = null;
        try {
            session.setProcess("Executing ...");
            Long1 long1 = Memory.init();
            statement = statement2 = (Statement)this.stmList.getFirst();
            while (statement != null && !session.comm.isOff()) {
                n2 = statement.getLineNumber();
                session.setScriptLine(n2);
                statement.execute(session);
                this.hasFailure |= statement.hasFailures();
                Memory.control(long1, session.db.base);
                statement = (Statement)this.stmList.getNext();
            }
        }
        catch (ZException zException) {
            this.hasFailure = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.hasFailure = true;
            new Failure(session, exception, n2, statement.expressBegin());
        }
        try {
            session.dbh.closeExecuted();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.hasFailure = true;
            new Failure(session, iOException, n, statement2.expressBegin());
        }
        session.clearProcess();
    }

    public String getText() {
        return this.text;
    }

    public Statement[] statements() {
        if (!this.isAnalyzed) {
            return null;
        }
        int n = this.stmList.size();
        Statement[] statementArray = new Statement[n];
        Statement statement = (Statement)this.stmList.getFirst();
        for (int i = 0; i < n; ++i) {
            statementArray[i] = statement;
            statement = (Statement)this.stmList.getNext();
        }
        return statementArray;
    }

    public boolean hasStatements() {
        return !this.stmList.isEmpty();
    }

    public int countStatements() {
        return this.stmList.size();
    }

    public boolean hasWarnings() {
        return this.hasErrors() || this.hasFailures();
    }

    public boolean hasErrors() {
        return this.hasError;
    }

    public boolean hasFailures() {
        return this.hasFailure;
    }

    String correct() {
        if (!this.isAnalyzed) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Statement[] statementArray = this.statements();
        int n = statementArray.length;
        for (int i = 0; i < n; ++i) {
            Statement statement = statementArray[i];
            String string = statement.rightExpression();
            stringBuffer.append(string);
            if (string.length() == 0) {
                stringBuffer.append("; <?>");
            } else if (statement.hasErrors()) {
                stringBuffer.append("; <!>");
            } else {
                stringBuffer.append(";");
            }
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }
}

