/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Parser.Fielder;
import Sav.Processor.PList;
import Sav.Z.Copula;
import Sav.Z.Error;
import Sav.Z.Expression;
import Sav.Z.Failure;
import Sav.Z.Lexis;
import Sav.Z.Procedure;
import Sav.Z.Script;
import Sav.Z.Session;
import Sav.Z.Warning;
import Sav.Z.ZException;
import java.io.File;

public class Statement
implements Lexis {
    Session ss;
    Statement root;
    String text;
    int begin;
    int end;
    int pos;
    String rightExpress;
    Expression expression;
    Expression express;
    Copula copula;
    int iLine;
    String sNewBase;
    int pSource;
    File fData;
    int pData;
    PList errList = new PList();
    PList failList = new PList();
    Procedure proc;
    boolean modify;
    Script scr;

    Statement(String string) {
        this(string, 0);
    }

    Statement(int n, String string, int n2) {
        this(string, n2);
        this.setLineNumber(n);
    }

    Statement(String string, int n) {
        this.text = string;
        this.pos = n;
        this.begin = n;
        Fielder fielder = new Fielder(string, this.begin);
        this.end = fielder.hasNext() ? fielder.nextPos() : string.length();
    }

    Statement(Statement statement, int n, File file, int n2, int n3, String string, int n4) {
        this(n, file, n2, string, n4);
        this.root = statement;
        this.setLineNumber(n3);
    }

    Statement(int n, File file, int n2, String string, int n3) {
        this.text = string;
        this.pos = n3;
        this.fData = file;
        this.pData = n2;
        this.pSource = n;
        this.begin = n3;
        Fielder fielder = new Fielder(string, this.begin);
        this.end = fielder.hasNext() ? fielder.nextPos() : string.length();
    }

    void analyse(Session session) {
        this.analyse(session, null, 128);
    }

    void analyse(Session session, Expression expression, int n) {
        this.ss = session;
        if (this.root == null) {
            session.curStm = this;
        }
        this.expression = null;
        this.rightExpress = null;
        this.errList = new PList();
        this.express = new Expression(this);
        this.copula = new Copula(this);
        if (this.express.index <= 4 && this.express.index >= 1 && this.copula.index != 5) {
            this.express = new Expression(this, new Copula(this.text, this.express.end, 5, ' '), this.express);
        }
        while (this.copula.look != ';') {
            if (this.copula.index == 22) {
                new Error(this, this.copula.position, String.valueOf(String.valueOf(new StringBuffer("Unexpected '").append(this.copula.look).append("' right separator"))));
                this.copula = new Copula(this);
                continue;
            }
            this.parse(this.express, this.copula);
        }
        this.expression = this.express;
        this.expression.construe(expression, n);
        if (this.modify && !session.modify) {
            this.expression.warnErr0("Description for non-modifiable database");
            this.expression.index = -10;
        }
        if (this.root == null) {
            session.curStm = null;
        }
    }

    void parse(Expression expression, Copula copula) {
        this.express = new Expression(this);
        this.copula = new Copula(this);
        if (this.express.index <= 4 && this.express.index >= 1 && this.copula.index != 5) {
            this.express = new Expression(this, new Copula(this.text, this.express.end, 5, ' '), this.express);
        }
        if (this.copula.index == 14 && this.copula.index == copula.index && expression.index != -10 && this.express.index != -10) {
            new Error(this, this.copula.position, "Unexpected '/' divider");
            this.copula.index = 13;
            this.copula.look = (char)58;
        }
        switch (copula.index) {
            case 6: 
            case 7: 
            case 8: {
                while (this.copula.index < 22) {
                    this.parse(this.express, this.copula);
                }
                if (this.copula.look == ';') {
                    new Error(this, copula.position, String.valueOf(String.valueOf(new StringBuffer("Unclosed ").append(copula.look).append(" left separator"))));
                    this.end = this.copula.position;
                } else if ((char)(copula.look + 2) != this.copula.look && (char)(copula.look + '\u0001') != this.copula.look) {
                    new Error(this, this.copula.position, String.valueOf(String.valueOf(new StringBuffer("Inconsistent ").append(this.copula.look).append(" right separator"))));
                }
                if (this.express.index < 21) {
                    this.express = new Expression(this, new Copula(this.text, this.express.end, 21, ','), this.express);
                }
                this.express = new Expression(this, expression, copula, this.express);
                ++this.express.end;
                this.copula = new Copula(this);
                return;
            }
        }
        while (this.copula.index <= copula.index) {
            this.parse(this.express, this.copula);
        }
        this.express = this.concat(expression, copula, this.express);
    }

    Expression concat(Expression expression, Copula copula, Expression expression2) {
        if (copula.index == expression2.index) {
            Expression expression3 = (Expression)expression2.list.getFirst();
            expression2.list.setType(copula.look);
            expression2.insert(expression);
            return expression2;
        }
        return new Expression(this, expression, copula, expression2);
    }

    boolean isAnalyzed(Session session) {
        return this.expression != null && this.ss == session;
    }

    void execute(Session session) throws ZException {
        if (this.isEmpty()) {
            return;
        }
        this.failList = new PList();
        session.curStm = this;
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        ZException zException = null;
        try {
            this.expression.executeStatement();
        }
        catch (ZException zException2) {
            zException = zException2;
            session.dbh.regain();
            session.mh.regain();
            session.spec.regain();
        }
        if (zException != null) {
            throw zException;
        }
        session.curStm = null;
    }

    public boolean isEmpty() {
        return this.expression == null || this.expression.index == -10;
    }

    public int expressBegin() {
        if (this.expression == null) {
            return this.begin;
        }
        return this.expression.begin;
    }

    public int expressEnd() {
        if (this.expression == null) {
            return this.begin;
        }
        return this.expression.end;
    }

    public String express() {
        return this.text.substring(this.expressBegin(), this.expressEnd());
    }

    public int begin() {
        return this.begin;
    }

    public int end() {
        return this.end;
    }

    public String toString() {
        return this.text.substring(this.begin(), this.end());
    }

    String getText() {
        return this.text;
    }

    int index() {
        return this.expression.index;
    }

    boolean hasCopula() {
        return this.expression.copula != null;
    }

    void setLineNumber(int n) {
        this.iLine = n;
    }

    public int getLineNumber() {
        return this.iLine;
    }

    File getFData() {
        return this.fData;
    }

    int getPData() {
        return this.pData;
    }

    public String rightExpression() {
        if (this.rightExpress != null) {
            return this.rightExpress;
        }
        if (this.expression == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.expression.toStringBuffer(stringBuffer);
        this.rightExpress = stringBuffer.toString();
        return this.rightExpress;
    }

    public boolean hasWarnings() {
        return this.hasErrors() || this.hasFailures();
    }

    public boolean hasErrors() {
        return !this.errList.isEmpty();
    }

    public boolean hasFailures() {
        return !this.failList.isEmpty();
    }

    public Warning[] warnings() {
        int n;
        int n2 = this.countWarnings();
        Warning[] warningArray = new Warning[n2];
        Error[] errorArray = this.errors();
        int n3 = errorArray.length;
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            warningArray[n4++] = errorArray[n];
        }
        Failure[] failureArray = this.failures();
        n3 = failureArray.length;
        for (n = 0; n < n3; ++n) {
            warningArray[n4++] = failureArray[n];
        }
        return warningArray;
    }

    public Error[] errors() {
        int n = this.errList.size();
        Error[] errorArray = new Error[n];
        Error error = (Error)this.errList.getFirst();
        for (int i = 0; i < n; ++i) {
            errorArray[i] = error;
            error = (Error)this.errList.getNext();
        }
        return errorArray;
    }

    public Failure[] failures() {
        int n = this.failList.size();
        Failure[] failureArray = new Failure[n];
        Failure failure = (Failure)this.failList.getFirst();
        for (int i = 0; i < n; ++i) {
            failureArray[i] = failure;
            failure = (Failure)this.failList.getNext();
        }
        return failureArray;
    }

    int countWarnings() {
        return this.countErrors() + this.countFailures();
    }

    int countErrors() {
        return this.errList.size();
    }

    int countFailures() {
        return this.failList.size();
    }
}

