/*      microsft.c                           17.02.04       */
/*!
/  --------------------------------------------------------------
/  Copyright (C) 1993: Michael Braun
/                      Kaetinger Muehlenweg 103 A
/                      D-28816 Stuhr
/  --------------------------------------------------------------
/
/  This file contains some functions, which are available
/  under ms-dos, but not on the other operating systems.
/
*/

/****************************************************************
*                                                               *
*  BENUTZTE UNTERPROGRAMME (C LIBRARY)                          *
*                                                               *
****************************************************************/

#include "config.h"
#include "standard.h"
#include "microsft.h"


/****************************************************************
*                                                               *
*  BENUTZTE UNTERPROGRAMME / GLOBALE VARIABLEN                  *
*                                                               *
****************************************************************/


/****************************************************************
*                                                               *
*  ENDE DER DEKLARATIONEN                                       *
*                                                               *
****************************************************************/


/* -FF-  */

#if (ACT_OP_SYSTEM != MS_DOS) && (ACT_OP_SYSTEM != WIN_32)

/* hier stehen die routinen, die zwar bei microsoft existieren, */
/* aber kein ANSI-Standard sind. */

#if (!LINUX_FOR_CYGWIN) && (!OS_QNX6)

int stricmp (const char *string1, const char *string2)
{
   for (;;)
   {
      if (toupper(*string1) < toupper(*string2)) return -1;  /* unequal */
      if (toupper(*string1) > toupper(*string2)) return  1;  /* unequal */

      if (*string1 == '\0') break;  /* end of strings */

      string1++;
      string2++;
   }

   return 0;  /* strings are equal */
   
}  /* stricmp */

/* -FF-  */

int strnicmp (const char *string1, const char *string2, size_t max_len)
{
size_t len;
char st1, st2;   /* help variables for time optimization */

   for (len = 0 ; len < max_len ; len++)
   {
      st1 = toupper(*string1);
      st2 = toupper(*string2);

      if (st1 < st2) return -1;  /* unequal */
      if (st1 > st2) return  1;  /* unequal */

      if (st1 == '\0') break;  /* end of strings */

      string1++;
      string2++;
   }

   return 0;  /* strings are equal */
   
}  /* strnicmp */

#endif

/* -FF-  */

char * strupr (char *string)
{
char *txt;

   txt = string;
   
   while (*txt)
   {
      *txt = (char) toupper (*txt);
      txt++;
   }

   return string;
}  /* strupr */

/* -FF-  */

char *ltoa (long value, char *string, int radix)
{
/* long to ascii, radix 2, 8, 10 or 16 */

int ii, jj, nz_flag;

   switch (radix)
   {
      case  8: sprintf (string, "%lo", value); break;   /* octal */
      case 10: sprintf (string, "%ld", value); break;   /* decimal */
      case 16: sprintf (string, "%lx", value); break;   /* hex */

      case  2:  /* format %lb gibt es leider nicht */   /* binary */
         jj = 0;
         nz_flag = 0;
         memset (string, 0, sizeof(string));

         for (ii = 0 ; ii < 32 ; ii++)
         {
            if (value & 0x80000000)    /* start string with first non zero */
               nz_flag = 1;

            if ((nz_flag) || (ii == 31))
            {
               if (value & 0x80000000)
                  string [jj] = '1';
               else
                  string [jj] = '0';

               jj++;
            }

            value <<= 1;
         }
         string [jj] = '\0';           /* forced end of string */
         break;
  
      default:
         *string = '\0';               /* empty string */
         break;
   }

   return string;
}  /* ltoa */

/* -FF-  */

unsigned long _lrotl (unsigned long arg, int count)
{
int ii;

   for (ii = 0 ; ii < count ; ii++)
   {
      if ((arg & 0x80000000) == 0)
      {
         arg <<= 1;    /* shift ohne carry */
      }
      else
      {
         arg <<= 1;    /* shift mit carry */
         arg++;
      }
   }

   return arg; 
}  /* _lrotl */

/* -FF-  */

unsigned long _lrotr (unsigned long arg, int count)
{
int ii;

   for (ii = 0 ; ii < count ; ii++)
   {
      if ((arg & 0x1) == 0)
      {
         arg >>= 1;    /* shift ohne carry */
      }
      else
      {
         arg >>= 1;    /* shift mit carry */
         arg += 0x80000000;
      }
   }

   return arg; 
}  /* _lrotr */

#endif

/* -FF-  */

/* Modification History */
/* 03.12.92 - file erzeugt */
/* 06.05.94 - ltoa: sonderfall value = 0, bei radix 2 */
/* 11.05.94 - strnicmp: tuned for speed */
/* 07.05.03 - LINUX_FOR_CYGWIN */
/* 17.02.04 - QNX6: New ! */
