/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import nu.xom.samples.BudgetData;

public class AttributesXMLBudget {
    public static void convert(List<Map<String, String>> list, OutputStream outputStream) throws IOException {
        Element element;
        Element element2 = new Element("Budget");
        Document document = new Document(element2);
        Iterator<Map<String, String>> iterator = list.iterator();
        while (iterator.hasNext()) {
            element = new Element("LineItem");
            Map<String, String> map = iterator.next();
            AttributesXMLBudget.setYear(element, "AgencyCode", map);
            AttributesXMLBudget.setYear(element, "AgencyName", map);
            AttributesXMLBudget.setYear(element, "BureauCode", map);
            AttributesXMLBudget.setYear(element, "BureauName", map);
            AttributesXMLBudget.setYear(element, "AccountCode", map);
            AttributesXMLBudget.setYear(element, "AccountName", map);
            AttributesXMLBudget.setYear(element, "TreasuryAgencyCode", map);
            AttributesXMLBudget.setYear(element, "SubfunctionCode", map);
            AttributesXMLBudget.setYear(element, "SubfunctionTitle", map);
            AttributesXMLBudget.setYear(element, "BEACategory", map);
            AttributesXMLBudget.setYear(element, "BudgetIndicator", map);
            AttributesXMLBudget.setAmount(element, "1976", map);
            Element element3 = new Element("Amount");
            element3.addAttribute(new Attribute("year", "TransitionalQuarter"));
            element3.appendChild(map.get("TransitionalQuarter"));
            for (int i = 1977; i <= 2006; ++i) {
                AttributesXMLBudget.setAmount(element, String.valueOf(i), map);
            }
        }
        element = new Serializer(outputStream, "UTF-8");
        element.write(document);
        element.flush();
    }

    private static void setYear(Element element, String string, Map<String, String> map) {
        element.addAttribute(new Attribute(string, map.get(string)));
    }

    private static void setAmount(Element element, String string, Map<String, String> map) {
        Element element2 = new Element("Amount");
        element2.addAttribute(new Attribute("year", String.valueOf(string)));
        element2.appendChild(map.get("Y" + string));
        element.appendChild((Node)element2);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.out.println("Usage: nu.xom.samples.AttributesXMLBudget infile outfile");
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            OutputStream outputStream = stringArray.length < 2 ? System.out : new FileOutputStream(stringArray[1]);
            List<Map<String, String>> list = BudgetData.parse(fileInputStream);
            AttributesXMLBudget.convert(list, outputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

