/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.samples.Account;
import nu.xom.samples.Agency;
import nu.xom.samples.Bureau;
import nu.xom.samples.Subfunction;

public class Budget {
    private List<Agency> agencies = new ArrayList<Agency>();
    private String year;

    public Budget(String string) {
        this.year = string;
    }

    public void add(Agency agency) {
        if (!this.agencies.contains(agency)) {
            this.agencies.add(agency);
        }
    }

    public void add(Map<String, String> map) {
        String string = map.get("AgencyName");
        String string2 = map.get("AgencyCode");
        String string3 = map.get("TreasuryAgencyCode");
        Agency agency = Agency.getInstance(string, string2, string3, this.year);
        this.add(agency);
        String string4 = map.get("BureauName");
        String string5 = map.get("BureauCode");
        Bureau bureau = Bureau.getInstance(string4, string5, string2, this.year);
        agency.add(bureau);
        String string6 = map.get("AccountName");
        String string7 = map.get("AccountCode");
        String string8 = map.get("BEACategory");
        Account account = Account.getInstance(string6, string7, string8, string5, string2, this.year);
        bureau.add(account);
        String string9 = map.get("SubfunctionTitle");
        String string10 = map.get("SubfunctionCode");
        String string11 = this.year;
        if (!string11.equals("TransitionalQuarter")) {
            string11 = "Y" + this.year;
        }
        long l = 1000L * Long.parseLong(map.get(string11));
        Subfunction subfunction = new Subfunction(string9, string10, l);
        account.add(subfunction);
    }

    public Element getXML() {
        Element element = new Element("Budget");
        element.addAttribute(new Attribute("year", String.valueOf(this.year)));
        for (Agency agency : this.agencies) {
            element.appendChild((Node)agency.getXML());
        }
        return element;
    }
}

