/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XMLException;

public class DatabaseBuilder {
    private Connection connection;

    public DatabaseBuilder(String string) throws SQLException {
        this.connection = DriverManager.getConnection(string);
    }

    public Document build(String string) throws SQLException, ParsingException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        Element element = new Element("table");
        while (resultSet.next()) {
            Element element2 = new Element("record");
            for (int i = 1; i <= n; ++i) {
                Element element3 = new Element("field");
                int n2 = resultSetMetaData.getColumnType(i);
                String string2 = DatabaseBuilder.getSchemaType(n2);
                Attribute attribute = new Attribute("xsi:type", "http://www.w3.org/2001/XMLSchema-instance", string2);
                element3.addAttribute(attribute);
                String string3 = resultSetMetaData.getColumnName(i);
                Attribute attribute2 = new Attribute("name", string3);
                element3.addAttribute(attribute2);
                Object object = resultSet.getObject(i);
                if (object == null) {
                    Attribute attribute3 = new Attribute("xsi:nil", "http://www.w3.org/2001/XMLSchema-instance", "true");
                    element3.addAttribute(attribute3);
                } else {
                    element3.appendChild(this.convertToXML(resultSet, i, n2));
                }
                element2.appendChild((Node)element3);
            }
            element.appendChild((Node)element2);
        }
        statement.close();
        element.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        return new Document(element);
    }

    private Node convertToXML(ResultSet resultSet, int n, int n2) throws SQLException, ParsingException {
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                return this.hexEncode(resultSet.getBinaryStream(n));
            }
            case 2004: {
                Blob blob = resultSet.getBlob(n);
                return this.hexEncode(blob.getBinaryStream());
            }
            case 2005: {
                Clob clob = resultSet.getClob(n);
                Reader reader = clob.getCharacterStream();
                char[] cArray = new char[1024];
                try {
                    int n3;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((n3 = reader.read(cArray, 0, 1024)) != -1) {
                        stringBuilder.append(this.escapeText(cArray, 0, n3));
                    }
                    return new Text(stringBuilder.toString());
                }
                catch (IOException iOException) {
                    throw new ParsingException("Read from CLOB failed", (Throwable)iOException);
                }
            }
            case 2003: {
                Array array = resultSet.getArray(n);
                return this.writeArray(array);
            }
        }
        Object object = resultSet.getObject(n);
        if (object == null) {
            return new Text("");
        }
        String string = object.toString();
        char[] cArray = string.toCharArray();
        return this.escapeText(cArray, 0, cArray.length);
    }

    private Text hexEncode(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                StringWriter stringWriter = new StringWriter(2);
                if (n < 16) {
                    stringWriter.write(48);
                }
                stringWriter.write(Integer.toHexString(n));
                stringBuilder.append(stringWriter.toString());
            }
            return new Text(stringBuilder.toString());
        }
        catch (IOException iOException) {
            throw new XMLException("Error while hex-encoding", (Throwable)iOException);
        }
    }

    private Text escapeText(char[] cArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(this.escapeChar(cArray[i]));
        }
        return new Text(stringBuilder.toString());
    }

    private char escapeChar(char c) {
        if (c >= ' ') {
            return c;
        }
        if (c == '\n') {
            return c;
        }
        if (c == '\r') {
            return c;
        }
        if (c == '\t') {
            return c;
        }
        return '\ufffd';
    }

    private Node writeArray(Array array) throws SQLException, ParsingException {
        ResultSet resultSet = array.getResultSet();
        int n = array.getBaseType();
        String string = DatabaseBuilder.getSchemaType(n);
        Element element = new Element("array");
        while (resultSet.next()) {
            Element element2 = new Element("component");
            element2.addAttribute(new Attribute("xsi:type", "http://www.w3.org/2001/XMLSchema-instance", string));
            element2.appendChild(this.convertToXML(resultSet, 2, n));
            element.appendChild((Node)element2);
        }
        return element;
    }

    public static String getSchemaType(int n) {
        switch (n) {
            case 2003: {
                return "array";
            }
            case -5: {
                return "xsd:long";
            }
            case -2: {
                return "xsd:hexBinary";
            }
            case -7: {
                return "xsd:boolean";
            }
            case 2004: {
                return "xsd:hexBinary";
            }
            case 1: {
                return "xsd:string";
            }
            case 2005: {
                return "xsd:string";
            }
            case 91: {
                return "xsd:date";
            }
            case 3: {
                return "xsd:decimal";
            }
            case 8: {
                return "xsd:double";
            }
            case 6: {
                return "xsd:decimal";
            }
            case 4: {
                return "xsd:int";
            }
            case 2000: {
                return "xsd:string";
            }
            case -4: {
                return "xsd:hexBinary";
            }
            case -1: {
                return "xsd:string";
            }
            case 2: {
                return "xsd:decimal";
            }
            case 7: {
                return "xsd:float";
            }
            case 2006: {
                return "xsd:IDREF";
            }
            case 5: {
                return "xsd:short";
            }
            case 2002: {
                return "struct";
            }
            case 92: {
                return "xsd:time";
            }
            case 93: {
                return "xsd:dateTime";
            }
            case -6: {
                return "xsd:byte";
            }
            case -3: {
                return "xsd:hexBinary";
            }
        }
        return "xsd:string";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java DatabaseBuilder URL query driverClass");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = "org.gjt.mm.mysql.Driver";
        if (stringArray.length >= 3) {
            string3 = stringArray[2];
        }
        try {
            Class.forName(string3).newInstance();
            DatabaseBuilder databaseBuilder = new DatabaseBuilder(string);
            Serializer serializer = new Serializer((OutputStream)System.out);
            serializer.setIndent(2);
            Document document = databaseBuilder.build(string2);
            serializer.write(document);
            serializer.flush();
        }
        catch (InstantiationException instantiationException) {
            System.out.println(string3 + " could not be instantiated");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(string3 + " could not be found");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

