/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import nu.xom.XMLException;

public class DatabaseConverter {
    private Connection connection;

    public DatabaseConverter(String string) throws SQLException {
        this.connection = DriverManager.getConnection(string);
    }

    public Document extract(String string) throws IOException {
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            Element element = new Element("table");
            while (resultSet.next()) {
                Element element2 = new Element("record");
                for (int i = 1; i <= n; ++i) {
                    Element element3 = new Element("field");
                    int n2 = resultSetMetaData.getColumnType(i);
                    String string2 = DatabaseConverter.getSchemaType(n2);
                    element3.addAttribute(new Attribute("xsi:type", "http://www.w3.org/2001/XMLSchema-instance", string2, Attribute.Type.NMTOKEN));
                    String string3 = resultSetMetaData.getColumnName(i);
                    element3.addAttribute(new Attribute("name", string3));
                    Object object = resultSet.getObject(i);
                    if (object == null) {
                        element3.addAttribute(new Attribute("xsi:nil", "http://www.w3.org/2001/XMLSchema-instance", "true"));
                    } else {
                        element3.appendChild(this.convertToXML(resultSet, i, n2));
                    }
                    element2.appendChild((Node)element3);
                }
                element.appendChild((Node)element2);
            }
            statement.close();
            return new Document(element);
        }
        catch (SQLException sQLException) {
            throw new XMLException("SQL error", (Throwable)sQLException);
        }
    }

    private Node convertToXML(ResultSet resultSet, int n, int n2) throws SQLException, IOException {
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                return this.hexEncode(resultSet.getBinaryStream(n));
            }
            case 2004: {
                Blob blob = resultSet.getBlob(n);
                return this.hexEncode(blob.getBinaryStream());
            }
            case 2005: {
                int n3;
                Clob clob = resultSet.getClob(n);
                Reader reader = clob.getCharacterStream();
                char[] cArray = new char[1024];
                StringBuilder stringBuilder = new StringBuilder();
                while ((n3 = reader.read(cArray, 0, 1024)) != -1) {
                    stringBuilder.append(cArray, 0, n3);
                }
                return new Text(stringBuilder.toString());
            }
            case 2003: {
                Array array = resultSet.getArray(n);
                return this.writeArray(array);
            }
        }
        Object object = resultSet.getObject(n);
        if (object == null) {
            return new Text("");
        }
        return new Text(object.toString());
    }

    private Text hexEncode(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read()) != -1) {
            if (n < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        return new Text(stringBuilder.toString());
    }

    private Element writeArray(Array array) throws IOException, SQLException {
        Element element = new Element("array");
        ResultSet resultSet = array.getResultSet();
        int n = array.getBaseType();
        String string = DatabaseConverter.getSchemaType(n);
        while (resultSet.next()) {
            Element element2 = new Element("component");
            element2.addAttribute(new Attribute("xsi:type", "http://www.w3.org/2001/XMLSchema-instance", string));
            element2.appendChild(this.convertToXML(resultSet, 2, n));
            element.appendChild((Node)element2);
        }
        return element;
    }

    public static String getSchemaType(int n) {
        switch (n) {
            case 2003: {
                return "array";
            }
            case -5: {
                return "xsd:long";
            }
            case -2: {
                return "xsd:hexBinary";
            }
            case -7: {
                return "xsd:boolean";
            }
            case 2004: {
                return "xsd:hexBinary";
            }
            case 1: {
                return "xsd:string";
            }
            case 2005: {
                return "xsd:string";
            }
            case 91: {
                return "xsd:date";
            }
            case 3: {
                return "xsd:decimal";
            }
            case 8: {
                return "xsd:double";
            }
            case 6: {
                return "xsd:decimal";
            }
            case 4: {
                return "xsd:int";
            }
            case 2000: {
                return "xsd:string";
            }
            case -4: {
                return "xsd:hexBinary";
            }
            case -1: {
                return "xsd:string";
            }
            case 2: {
                return "xsd:decimal";
            }
            case 7: {
                return "xsd:float";
            }
            case 2006: {
                return "xsd:IDREF";
            }
            case 5: {
                return "xsd:short";
            }
            case 2002: {
                return "struct";
            }
            case 92: {
                return "xsd:time";
            }
            case 93: {
                return "xsd:dateTime";
            }
            case -6: {
                return "xsd:byte";
            }
            case -3: {
                return "xsd:hexBinary";
            }
        }
        return "xsd:string";
    }
}

