/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;

public class ExampleExtractor {
    private static int chapter = 0;

    public static void extract(Element element) throws IOException {
        for (Element element2 : element.getChildElements()) {
            if (element2.getQualifiedName().equals("chapter")) {
                ++chapter;
            }
            if (element2.getQualifiedName().equals("example")) {
                ExampleExtractor.extractExample(element2, chapter);
                continue;
            }
            ExampleExtractor.extract(element2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractExample(Element element, int n) throws IOException {
        String string = element.getAttribute("id").getValue();
        Element element2 = element.getFirstChildElement("programlisting");
        if (element2 == null) {
            element2 = element.getFirstChildElement("screen");
        }
        if (element2 == null) {
            return;
        }
        String string2 = element2.getValue();
        File file = new File("examples2/" + n);
        file.mkdirs();
        File file2 = new File(file, string);
        System.out.println(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Writer writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        try {
            writer = new BufferedWriter(writer);
            writer.write(string2);
            writer.flush();
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.ExampleExtractor URL");
            return;
        }
        String string = stringArray[0];
        try {
            Builder builder = new Builder();
            Document document = builder.build(stringArray[0]);
            ExampleExtractor.extract(document.getRootElement());
        }
        catch (ParsingException parsingException) {
            System.out.println((Object)parsingException);
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + string);
            System.out.println(iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println(outOfMemoryError);
            outOfMemoryError.printStackTrace();
        }
    }
}

