/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;

public class FibonacciSOAPClient {
    public static final String defaultServer = "http://www.elharo.com/fibonacci/SOAP";
    public static final String SOAP_ACTION = "http://www.example.com/fibonacci";

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java nu.xom.samples.FibonacciSOAPClient index serverURL");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray.length <= 1 ? defaultServer : stringArray[1];
        Document document = FibonacciSOAPClient.buildRequest(string);
        try {
            URL uRL = new URL(string2);
            URLConnection uRLConnection = uRL.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("SOAPAction", SOAP_ACTION);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            Serializer serializer = new Serializer(outputStream, "US-ASCII");
            serializer.write(document);
            serializer.flush();
            InputStream inputStream = httpURLConnection.getInputStream();
            Builder builder = new Builder();
            Document document2 = builder.build(inputStream);
            inputStream.close();
            outputStream.close();
            httpURLConnection.disconnect();
            Element element = document2.getRootElement();
            Element element2 = element.getFirstChildElement("Body", "http://schemas.xmlsoap.org/soap/envelope/");
            Element element3 = element2.getFirstChildElement("Fault", "http://schemas.xmlsoap.org/soap/envelope/");
            if (element3 == null) {
                Element element4 = element2.getFirstChildElement("Fibonacci_Numbers", "http://namespaces.cafeconleche.org/xmljava/ch3/");
                Elements elements = element4.getChildElements("fibonacci", "http://namespaces.cafeconleche.org/xmljava/ch3/");
                for (Element element5 : elements) {
                    System.out.println(element5.getValue());
                }
            } else {
                FibonacciSOAPClient.handleFault(element3);
            }
        }
        catch (ParsingException parsingException) {
            System.err.println("Server sent malformed output");
            System.err.println((Object)parsingException);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Server sent invalid output without the expected content.");
            System.err.println(nullPointerException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace();
        }
    }

    private static void handleFault(Element element) {
        Element element2 = element.getFirstChildElement("faultcode");
        Element element3 = element.getFirstChildElement("faultstring");
        Element element4 = element.getFirstChildElement("faultactor");
        Element element5 = element.getFirstChildElement("detail");
        String string = "Fault: \n";
        if (element2 != null) {
            string = string + "Fault code: " + element2.getValue() + "\n";
        }
        if (element3 != null) {
            string = string + "Fault string: " + element3.getValue() + "\n";
        }
        if (element4 != null) {
            string = string + "Fault actor: " + element4.getValue() + "\n";
        }
        if (element5 != null) {
            string = string + "Details: " + element5.getValue() + "\n";
        }
    }

    public static Document buildRequest(String string) {
        String string2 = "http://schemas.xmlsoap.org/soap/envelope/";
        Element element = new Element("SOAP-ENV:Envelope", string2);
        Element element2 = new Element("SOAP-ENV:Body", string2);
        Element element3 = new Element("calculateFibonacci", "http://namespaces.cafeconleche.org/xmljava/ch3/");
        element3.appendChild(string);
        element3.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Attribute attribute = new Attribute("type", "xsi:positiveInteger");
        element3.addAttribute(attribute);
        element.appendChild((Node)element2);
        element2.appendChild((Node)element3);
        Document document = new Document(element);
        return document;
    }
}

