/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import nu.xom.samples.BudgetData;

public class FlatXMLBudget {
    public static void convert(List<Map<String, String>> list, OutputStream outputStream) throws IOException {
        Element element = new Element("Budget");
        Document document = new Document(element);
        for (Map<String, String> map : list) {
            Element element2 = new Element("LineItem");
            Set<Map.Entry<String, String>> set = map.entrySet();
            for (Map.Entry<String, String> entry : set) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                Element element3 = new Element(string);
                element3.appendChild(string2);
                element2.appendChild((Node)element3);
            }
            element.appendChild((Node)element2);
        }
        Serializer serializer = new Serializer(outputStream, "UTF-8");
        serializer.write(document);
        serializer.flush();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.out.println("Usage: nu.xom.samples.FlatXMLBudget infile outfile");
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            OutputStream outputStream = stringArray.length < 2 ? System.out : new FileOutputStream(stringArray[1]);
            List<Map<String, String>> list = BudgetData.parse(fileInputStream);
            FlatXMLBudget.convert(list, outputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

