/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;

public class NodeLister {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java nu.xom.samples.NodeLister URL");
            return;
        }
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            Element element = document.getRootElement();
            NodeLister.listChildren((Node)element, 0);
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public static void listChildren(Node node, int n) {
        NodeLister.printSpaces(n);
        String string = "";
        if (node instanceof Element) {
            Element element = (Element)node;
            string = ": " + element.getQualifiedName();
        }
        System.out.println(node.getClass().getName() + string);
        for (int i = 0; i < node.getChildCount(); ++i) {
            NodeLister.listChildren(node.getChild(i), n + 1);
        }
    }

    private static void printSpaces(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
    }
}

