/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

public class PropertyPrinter {
    private Writer out;
    private int nodeCount = 0;

    public PropertyPrinter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Writer must be non-null.");
        }
        this.out = writer;
    }

    public PropertyPrinter() {
        this(new OutputStreamWriter(System.out));
    }

    public void writeNode(Node node) throws IOException {
        Object object;
        if (node == null) {
            throw new NullPointerException("Node must be non-null.");
        }
        if (node instanceof Document) {
            this.nodeCount = 1;
        }
        String string = node.getClass().getName();
        String string2 = node.getValue();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (node instanceof Element) {
            object = (Element)node;
            string3 = object.getQualifiedName();
            string4 = object.getLocalName();
            string5 = object.getNamespaceURI();
            string6 = object.getNamespacePrefix();
        } else if (node instanceof Attribute) {
            object = (Attribute)node;
            string3 = object.getQualifiedName();
            string4 = object.getLocalName();
            string5 = object.getNamespaceURI();
            string6 = object.getNamespacePrefix();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Node " + this.nodeCount + ":\r\n");
        ((StringBuilder)object).append("  Type: " + string + "\r\n");
        if (string3 != null) {
            ((StringBuilder)object).append("  Name: " + string3 + "\r\n");
        }
        if (string4 != null) {
            ((StringBuilder)object).append("  Local Name: " + string4 + "\r\n");
        }
        if (string6 != null) {
            ((StringBuilder)object).append("  Prefix: " + string6 + "\r\n");
        }
        if (string5 != null) {
            ((StringBuilder)object).append("  Namespace URI: " + string5 + "\r\n");
        }
        if (string2 != null) {
            ((StringBuilder)object).append("  Value: " + string2 + "\r\n");
        }
        this.out.write(((StringBuilder)object).toString());
        this.out.write("\r\n");
        this.out.flush();
        ++this.nodeCount;
    }
}

