/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ParsingException;

public class RDDLStripper {
    public static final String RDDL_NAMESPACE = "http://www.rddl.org/";

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.RDDLStripper URL");
            return;
        }
        try {
            Builder builder = new Builder();
            Document document = builder.build(stringArray[0]);
            RDDLStripper.strip(document.getRootElement());
            System.out.println(document.toXML());
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + stringArray[0]);
        }
    }

    public static void strip(Element element) {
        if (element.getNamespaceURI().equals(RDDL_NAMESPACE)) {
            int n;
            ParentNode parentNode = element.getParent();
            for (n = 0; n < parentNode.getChildCount() && parentNode.getChild(n) != element; ++n) {
            }
            parentNode.removeChild(n);
            while (element.getChildCount() > 0) {
                Node node = element.getChild(0);
                element.removeChild(0);
                parentNode.insertChild(node, n);
                ++n;
                if (!(node instanceof Element)) continue;
                RDDLStripper.strip((Element)node);
            }
        } else {
            for (Element element2 : element.getChildElements()) {
                RDDLStripper.strip(element2);
            }
        }
    }
}

