/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Text;

public class ROT13XML {
    public static void encode(Node node) {
        if (node instanceof Text) {
            Text text = (Text)node;
            String string = text.getValue();
            text.setValue(ROT13XML.rot13(string));
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ROT13XML.encode(node.getChild(i));
        }
    }

    public static String rot13(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'M') {
                stringBuilder.append((char)(c + 13));
                continue;
            }
            if (c >= 'N' && c <= 'Z') {
                stringBuilder.append((char)(c - 13));
                continue;
            }
            if (c >= 'a' && c <= 'm') {
                stringBuilder.append((char)(c + 13));
                continue;
            }
            if (c >= 'n' && c <= 'z') {
                stringBuilder.append((char)(c - 13));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.ROT13XML URL");
            return;
        }
        String string = stringArray[0];
        try {
            Builder builder = new Builder();
            Document document = builder.build(string);
            ROT13XML.encode((Node)document);
            System.out.println(document.toXML());
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not encode " + string);
        }
        catch (ParsingException parsingException) {
            System.out.println((Object)parsingException);
        }
    }
}

