/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.samples.MinimalNodeFactory;

public class RSSHeadlines
extends MinimalNodeFactory {
    private boolean inTitle = false;
    private Nodes empty = new Nodes();

    @Override
    public Element startMakingElement(String string, String string2) {
        if ("title".equals(string)) {
            this.inTitle = true;
        }
        return new Element(string, string2);
    }

    @Override
    public Nodes makeText(String string) {
        if (this.inTitle) {
            System.out.print(string);
        }
        return this.empty;
    }

    public Nodes finishMakingElement(Element element) {
        if ("title".equals(element.getQualifiedName())) {
            System.out.println();
            this.inTitle = false;
        }
        return new Nodes((Node)element);
    }

    public static void main(String[] stringArray) {
        String string = "http://www.bbc.co.uk/syndication/feeds/news/ukfs_news/world/rss091.xml";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            Builder builder = new Builder((NodeFactory)new RSSHeadlines());
            builder.build(string);
        }
        catch (ParsingException parsingException) {
            System.out.println(string + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + string);
        }
    }
}

