/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class SourceCodeGenerator {
    private static int elementCount = 1;

    public static void main(String[] stringArray) {
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            SourceCodeGenerator.generateClass(document);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public static void generateClass(Document document) {
        System.out.println("import nu.xom.*;");
        System.out.println();
        System.out.println();
        System.out.println("public class CodeMaker {");
        System.out.println();
        System.out.println("  public static void main(String[] args) throws Exception {");
        SourceCodeGenerator.generateDoc(document);
        System.out.println("    Serializer serializer = new Serializer(System.out);");
        System.out.println("    serializer.write(doc);");
        System.out.println("  }");
        System.out.println();
        System.out.println("}");
    }

    public static void generateSource(Node node, String string) {
        if (node instanceof Element) {
            Object object2;
            int n;
            Element element = (Element)node;
            String string2 = "element" + elementCount;
            System.out.println("    Element " + string2 + " = new Element(\"" + element.getQualifiedName() + "\", \"" + element.getNamespaceURI() + "\");");
            if ("doc".equals(string)) {
                System.out.println("    doc.setRootElement(" + string2 + ");");
            } else {
                System.out.println("    " + string + ".appendChild(" + string2 + ");");
            }
            for (n = 0; n < element.getAttributeCount(); ++n) {
                object2 = element.getAttribute(n);
                System.out.println("    " + string2 + ".addAttribute(new Attribute(\"" + object2.getQualifiedName() + "\", \"" + object2.getNamespaceURI() + "\", \"" + object2.getValue() + "\"));");
            }
            for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
                object2 = element.getNamespacePrefix(n);
                System.out.println("    " + string2 + ".addNamespaceDeclaration(\"" + (String)object2 + "\", \"" + element.getNamespaceURI((String)object2) + "\");");
            }
            ++elementCount;
            for (Object object2 : element.getChildElements()) {
                SourceCodeGenerator.generateSource((Node)object2, string2);
            }
        } else if (node instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            System.out.println("    pi = new ProcessingInstruction(\"" + processingInstruction.getTarget() + "\", \"" + SourceCodeGenerator.javaEscape(processingInstruction.getValue()) + "\");");
            System.out.println("    " + string + ".appendChild(pi);");
        } else if (node instanceof Comment) {
            Comment comment = (Comment)node;
            System.out.println("    comment = new Comment(\"" + SourceCodeGenerator.javaEscape(comment.getValue()) + "\");");
            System.out.println("    " + string + ".appendChild(comment);");
        } else if (node instanceof Text) {
            Text text = (Text)node;
            System.out.println("    text = new Text(\"" + SourceCodeGenerator.javaEscape(text.getValue()) + "\");");
            System.out.println("    " + string + ".appendChild(text);");
        } else if (node instanceof DocType) {
            DocType docType = (DocType)node;
            String string3 = docType.getPublicID();
            String string4 = docType.getSystemID();
            System.out.println("    DocType doctype = new DocType(\"" + docType.getRootElementName() + "\");");
            if (string4 != null) {
                System.out.println("    doctype.setSystemID(\"" + string4 + "\");");
            }
            if (string3 != null) {
                System.out.println("    doctype.setPublicID(\"" + string3 + "\");");
            }
            System.out.println("    doc.setDocType(doctype);");
        }
    }

    private static String javaEscape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block7;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static void generateDoc(Document document) {
        System.out.println("    Comment comment;");
        System.out.println("    Text text;");
        System.out.println("    ProcessingInstruction pi;");
        System.out.println("    Document doc = new Document(new Element(\"root\"));");
        for (int i = 0; i < document.getChildCount(); ++i) {
            SourceCodeGenerator.generateSource(document.getChild(i), "doc");
        }
    }
}

