/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParsingException;

public class StreamingExampleExtractor
extends NodeFactory {
    private int chapter = 0;
    private boolean inExample = false;
    private Nodes empty = new Nodes();

    public Nodes makeComment(String string) {
        return this.empty;
    }

    public Nodes makeText(String string) {
        if (this.inExample) {
            return super.makeText(string);
        }
        return this.empty;
    }

    public Element makeRootElement(String string, String string2) {
        if ("example".equals(string)) {
            this.inExample = true;
        }
        if ("chapter".equals(string)) {
            ++this.chapter;
        }
        return super.startMakingElement(string, string2);
    }

    public Element startMakingElement(String string, String string2) {
        if ("example".equals(string)) {
            this.inExample = true;
        }
        if ("chapter".equals(string)) {
            ++this.chapter;
        }
        if (this.inExample) {
            return super.startMakingElement(string, string2);
        }
        return null;
    }

    public Nodes finishMakingElement(Element element) {
        if (element.getQualifiedName().equals("example")) {
            try {
                StreamingExampleExtractor.extractExample(element, this.chapter);
            }
            catch (IOException iOException) {
                System.err.println("Problem writing " + element.getAttributeValue("id") + " in chapter " + this.chapter);
            }
            this.inExample = false;
        }
        return new Nodes((Node)element);
    }

    public Nodes makeAttribute(String string, String string2, String string3, Attribute.Type type) {
        if (this.inExample && string.equals("id")) {
            return super.makeAttribute(string, string2, string3, type);
        }
        return this.empty;
    }

    public Nodes makeDocType(String string, String string2, String string3) {
        return this.empty;
    }

    public Nodes makeProcessingInstruction(String string, String string2) {
        return this.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractExample(Element element, int n) throws IOException {
        String string = element.getAttribute("id").getValue();
        System.out.println(string);
        Element element2 = element.getFirstChildElement("programlisting");
        if (element2 == null) {
            element2 = element.getFirstChildElement("screen");
        }
        if (element2 == null) {
            return;
        }
        String string2 = element2.getValue();
        File file = new File("examples2/" + n);
        file.mkdirs();
        File file2 = new File(file, string);
        System.out.println(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            writer = new BufferedWriter(writer);
            writer.write(string2);
            writer.flush();
        }
        finally {
            fileOutputStream.close();
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.StreamingExampleExtractor URL");
            return;
        }
        String string = stringArray[0];
        try {
            Builder builder = new Builder((NodeFactory)new StreamingExampleExtractor());
            builder.build(stringArray[0]);
        }
        catch (ParsingException parsingException) {
            System.out.println((Object)parsingException);
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + string);
            System.out.println(iOException);
        }
    }
}

