/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParsingException;

public class StreamingTextExtractor
extends NodeFactory {
    private Writer out;
    private Nodes empty = new Nodes();

    public StreamingTextExtractor(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Writer must be non-null.");
        }
        this.out = writer;
    }

    public StreamingTextExtractor() {
        this(new OutputStreamWriter(System.out));
    }

    public Nodes makeComment(String string) {
        return this.empty;
    }

    public Nodes makeText(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return this.empty;
    }

    public Element makeRootElement(String string, String string2) {
        Element element = new Element(string, string2);
        return element;
    }

    public Element startMakingElement(String string, String string2) {
        return null;
    }

    public Nodes makeAttribute(String string, String string2, String string3, Attribute.Type type) {
        return this.empty;
    }

    public Nodes makeDocType(String string, String string2, String string3) {
        return this.empty;
    }

    public Nodes makeProcessingInstruction(String string, String string2) {
        return this.empty;
    }

    public void finishMakingDocument(Document document) {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.StreamingTextExtractor URL");
            return;
        }
        try {
            Builder builder = new Builder((NodeFactory)new StreamingTextExtractor());
            builder.build(stringArray[0]);
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + stringArray[0]);
        }
    }
}

