/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.Serializer;

public class StreamingXHTMLPurifier
extends NodeFactory {
    private Stack<String> namespaces = new Stack();
    private Nodes empty = new Nodes();
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";

    public Nodes makeText(String string) {
        if (this.inXHTML()) {
            return super.makeText(string);
        }
        return this.empty;
    }

    public Nodes makeComment(String string) {
        if (this.inXHTML()) {
            return super.makeComment(string);
        }
        return this.empty;
    }

    private boolean inXHTML() {
        if (this.namespaces.isEmpty()) {
            return true;
        }
        String string = this.namespaces.peek();
        return XHTML_NAMESPACE.equals(string);
    }

    public Element startMakingElement(String string, String string2) {
        this.namespaces.push(string2);
        if (XHTML_NAMESPACE.equals(string2)) {
            return super.startMakingElement(string, string2);
        }
        return null;
    }

    public Nodes finishMakingElement(Element element) {
        this.namespaces.pop();
        int n = element.getNamespaceDeclarationCount();
        for (int i = 0; i < n; ++i) {
            String string = element.getNamespacePrefix(i);
            element.removeNamespaceDeclaration(string);
            if (element.getNamespaceDeclarationCount() >= n) continue;
            --i;
            --n;
        }
        return new Nodes((Node)element);
    }

    public Nodes makeDocType(String string, String string2, String string3) {
        return new Nodes((Node)new DocType("html", "PUBLIC \"-//W3C//DTD XHTML Basic 1.0//EN\"", "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd"));
    }

    public Nodes makeProcessingInstruction(String string, String string2) {
        if (this.inXHTML()) {
            return super.makeProcessingInstruction(string, string2);
        }
        return this.empty;
    }

    public Nodes makeAttribute(String string, String string2, String string3, Attribute.Type type) {
        if ("".equals(string2) || "http://www.w3.org/XML/1998/namespace".equals(string2)) {
            return super.makeAttribute(string, string2, string3, type);
        }
        return this.empty;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java nu.xom.samples.StreamingXHTMLPurifier URL");
            return;
        }
        StreamingXHTMLPurifier streamingXHTMLPurifier = new StreamingXHTMLPurifier();
        Builder builder = new Builder((NodeFactory)streamingXHTMLPurifier);
        try {
            Document document = builder.build(stringArray[0]);
            Serializer serializer = new Serializer((OutputStream)System.out);
            serializer.write(document);
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
            parsingException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

