/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;

public class WrappingSerializer
extends Serializer {
    private int maxLength;

    public WrappingSerializer(OutputStream outputStream) {
        super(outputStream);
    }

    public WrappingSerializer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    protected void writeStartTag(Element element) throws IOException {
        this.writeRaw("<");
        this.writeRaw(element.getQualifiedName());
        this.writeAttributes(element);
        this.writeNamespaceDeclarations(element);
        if (this.needsBreak()) {
            this.breakLine();
        }
        this.writeRaw(">");
    }

    protected void writeEmptyElementTag(Element element) throws IOException {
        this.writeRaw("<");
        this.writeRaw(element.getQualifiedName());
        this.writeAttributes(element);
        this.writeNamespaceDeclarations(element);
        if (this.needsBreak()) {
            this.breakLine();
        }
        this.writeRaw("/>");
    }

    public void writeEndTag(Element element) throws IOException {
        this.writeRaw("<");
        this.writeRaw(element.getQualifiedName());
        if (this.needsBreak()) {
            this.breakLine();
        }
        this.writeRaw("/>");
    }

    protected void write(Attribute attribute) throws IOException {
        String string = attribute.getQualifiedName();
        if (this.maxLength <= this.getColumnNumber() + string.length()) {
            this.breakLine();
        }
        this.writeRaw(string);
        if (this.getColumnNumber() == this.maxLength) {
            this.breakLine();
        }
        this.writeRaw("=");
        String string2 = attribute.getValue();
        if (this.maxLength < string2.length() + 2) {
            this.breakLine();
        }
        this.writeRaw("\"");
        this.writeAttributeValue(attribute.getValue());
        this.writeRaw("\"");
    }

    protected void writeNamespaceDeclaration(String string, String string2) throws IOException {
        String string3 = "".equals(string) ? "xmlns" : "xmlns:" + string;
        if (this.maxLength < this.getColumnNumber() + string3.length()) {
            this.breakLine();
        }
        this.writeRaw(string3);
        if (this.getColumnNumber() == this.maxLength) {
            this.breakLine();
        }
        this.writeRaw("=");
        if (this.maxLength < this.getColumnNumber() + string2.length() + 2) {
            this.breakLine();
        }
        this.writeRaw("\"");
        this.writeEscaped(string2);
        this.writeRaw("\"");
    }

    private boolean needsBreak() {
        if (this.maxLength > 0) {
            return this.maxLength - this.getColumnNumber() <= 10;
        }
        return false;
    }

    protected void write(ProcessingInstruction processingInstruction) throws IOException {
        this.writeRaw("<?");
        this.writeRaw(processingInstruction.getTarget());
        String string = processingInstruction.getValue();
        if (this.maxLength < this.getColumnNumber() + string.length() + 3) {
            this.breakLine();
        } else {
            this.writeRaw(" ");
        }
        this.writeRaw(string);
        this.writeRaw("?>");
    }

    protected void write(DocType docType) throws IOException {
        this.writeRaw("<!DOCTYPE");
        String string = docType.getRootElementName();
        if (this.maxLength < this.getColumnNumber() + string.length() + 1) {
            this.breakLine();
        } else {
            this.writeRaw(" ");
        }
        this.writeRaw(string);
        String string2 = docType.getPublicID();
        String string3 = docType.getSystemID();
        if (string2 != null) {
            if (this.maxLength < this.getColumnNumber() + 6) {
                this.breakLine();
            } else {
                this.writeRaw(" ");
            }
            this.writeRaw("PUBLIC");
            if (this.maxLength < this.getColumnNumber() + string2.length() + 2) {
                this.breakLine();
            } else {
                this.writeRaw(" ");
            }
            this.writeRaw("\"");
            this.writeRaw(string2);
            this.writeRaw("\"");
            if (this.maxLength < this.getColumnNumber() + string3.length() + 2) {
                this.breakLine();
            } else {
                this.writeRaw(" ");
            }
            this.writeRaw("\"");
            this.writeRaw(string3);
            this.writeRaw("\"");
        } else if (string3 != null) {
            if (this.maxLength < this.getColumnNumber() + 6) {
                this.breakLine();
            } else {
                this.writeRaw(" ");
            }
            this.writeRaw("SYSTEM");
            if (this.maxLength < this.getColumnNumber() + string3.length() + 2) {
                this.breakLine();
            } else {
                this.writeRaw(" ");
            }
            this.writeRaw("\"");
            this.writeRaw(string3);
            this.writeRaw("\"");
        }
        String string4 = docType.getInternalDTDSubset();
        if (!string4.equals("")) {
            if (this.maxLength < this.getColumnNumber() + 2) {
                this.breakLine();
            } else {
                this.writeRaw(" ");
            }
            this.writeRaw("[");
            this.breakLine();
            this.writeRaw(string4);
            this.breakLine();
            this.writeRaw("]");
        }
        if (this.maxLength < this.getColumnNumber() + 1) {
            this.breakLine();
        }
        this.writeRaw(">");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.WrappingSerializer URL");
            return;
        }
        try {
            Builder builder = new Builder();
            Document document = builder.build(stringArray[0]);
            WrappingSerializer wrappingSerializer = new WrappingSerializer(System.out, "ISO-8859-1");
            wrappingSerializer.setIndent(4);
            wrappingSerializer.setMaxLength(24);
            wrappingSerializer.setPreserveBaseURI(true);
            wrappingSerializer.write(document);
            wrappingSerializer.flush();
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + stringArray[0]);
        }
    }
}

