/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.XPathException;
import nu.xom.XPathTypeException;

public class XPathDriver {
    public static void main(String[] stringArray) {
        Builder builder = new Builder();
        if (stringArray.length < 2) {
            System.out.println("Usage: java nu.xom.samples.XPathDriver URL xpath");
            return;
        }
        try {
            Document document = builder.build(stringArray[0]);
            for (Node node : document.query(stringArray[1])) {
                System.out.println(node.toXML());
            }
        }
        catch (XPathTypeException xPathTypeException) {
            System.err.println(xPathTypeException.getReturnValue());
        }
        catch (XPathException xPathException) {
            System.err.println("XPath error: " + xPathException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println("Could not read from " + stringArray[0]);
            System.err.println(iOException.getMessage());
        }
        catch (ParsingException parsingException) {
            System.err.println(stringArray[0] + " is malformed.");
            System.err.println(parsingException.getMessage());
        }
    }
}

